% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_map.R
\name{MAPClass}
\alias{MAPClass}
\title{General Markovian arrival process}
\description{
General Markovian arrival process

General Markovian arrival process
}
\details{
A point process dominated by a continuous-time Markov chain.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MAPClass-alpha}{\code{MAPClass$alpha()}}
\item \href{#method-MAPClass-D0}{\code{MAPClass$D0()}}
\item \href{#method-MAPClass-D1}{\code{MAPClass$D1()}}
\item \href{#method-MAPClass-xi}{\code{MAPClass$xi()}}
\item \href{#method-MAPClass-new}{\code{MAPClass$new()}}
\item \href{#method-MAPClass-copy}{\code{MAPClass$copy()}}
\item \href{#method-MAPClass-size}{\code{MAPClass$size()}}
\item \href{#method-MAPClass-df}{\code{MAPClass$df()}}
\item \href{#method-MAPClass-print}{\code{MAPClass$print()}}
\item \href{#method-MAPClass-mmoment}{\code{MAPClass$mmoment()}}
\item \href{#method-MAPClass-jmoment}{\code{MAPClass$jmoment()}}
\item \href{#method-MAPClass-acf}{\code{MAPClass$acf()}}
\item \href{#method-MAPClass-emfit}{\code{MAPClass$emfit()}}
\item \href{#method-MAPClass-init}{\code{MAPClass$init()}}
\item \href{#method-MAPClass-clone}{\code{MAPClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-alpha"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-alpha}{}}}
\subsection{Method \code{alpha()}}{
Get alpha
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$alpha()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of alpha
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-D0"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-D0}{}}}
\subsection{Method \code{D0()}}{
Get D0
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$D0()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A matrix of D0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-D1"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-D1}{}}}
\subsection{Method \code{D1()}}{
Get D1
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$D1()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A matrix of D1
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-xi"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-xi}{}}}
\subsection{Method \code{xi()}}{
Get xi
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$xi()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of xi
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-new"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-new}{}}}
\subsection{Method \code{new()}}{
Create a MAP
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$new(alpha, D0, D1, xi)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alpha}}{A vector of initial probability}

\item{\code{D0}}{An infinitesimal generator}

\item{\code{D1}}{An infinitesimal generator}

\item{\code{xi}}{An exit rate vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of MAP
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-copy"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-copy}{}}}
\subsection{Method \code{copy()}}{
copy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$copy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-size"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-size}{}}}
\subsection{Method \code{size()}}{
The number of phases
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of phases
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-df"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-df}{}}}
\subsection{Method \code{df()}}{
Degrees of freedom
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$df()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The degrees of freedom
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-print"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-print}{}}}
\subsection{Method \code{print()}}{
Print
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-mmoment"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-mmoment}{}}}
\subsection{Method \code{mmoment()}}{
Marginal moments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$mmoment(k, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{k}}{An integer of degree}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of moments
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-jmoment"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-jmoment}{}}}
\subsection{Method \code{jmoment()}}{
Joint moments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$jmoment(lag, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lag}}{An integer of lag}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix of moments
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-acf"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-acf}{}}}
\subsection{Method \code{acf()}}{
k-lag correlation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$acf(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector for k-lag correlation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-emfit"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-emfit}{}}}
\subsection{Method \code{emfit()}}{
Run EM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$emfit(data, options, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A dataframe}

\item{\code{options}}{A list of options}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-init"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-init}{}}}
\subsection{Method \code{init()}}{
Initialize with data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$init(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A dataframe}

\item{\code{...}}{Others}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MAPClass-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MAPClass-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MAPClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
