% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_maps.R
\name{merge_maps}
\alias{merge_maps}
\title{Merge two maps}
\usage{
merge_maps(
  map.list,
  twopt,
  thres.twopt = 10,
  genoprob.list = NULL,
  thres.hmm = "best",
  tol = 1e-04
)
}
\arguments{
\item{map.list}{a list of objects of class \code{mappoly.map} to be merged.}

\item{twopt}{an object of class \code{mappoly.twopt}
containing the two-point information for all pairs of markers
present in the original maps}

\item{thres.twopt}{the threshold used to determine if the linkage
phases compared via two-point analysis should be considered 
for the search space reduction (default = 3)}

\item{genoprob.list}{a list of objects of class \code{mappoly.genoprob} 
containing the genotype probabilities for the maps to be merged. 
If \code{NULL} (default), the probabilities are computed.}

\item{thres.hmm}{the threshold used to determine which linkage 
phase configurations should be returned when merging two maps.
If "best" (default), returns only the best linkage phase 
configuration. NOTE: if merging multiple maps, it always uses 
the "best" linkage phase configuration at each block insertion.}

\item{tol}{the desired accuracy (default = 10e-04)}
}
\value{
A list of class \code{mappoly.map} with two elements: 

i) info:  a list containing information about the map, regardless of the linkage phase configuration:
\item{ploidy}{the ploidy level}
\item{n.mrk}{number of markers}
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{mrk.names}{the names of markers in the map}
\item{seq.dose.p1}{a vector containing the dosage in parent 1 for all markers in the map}
\item{seq.dose.p2}{a vector containing the dosage in parent 2 for all markers in the map}
\item{chrom}{a vector indicating the sequence (usually chromosome) each marker belongs 
                as informed in the input file. If not available, 
                \code{chrom = NULL}}
\item{genome.pos}{physical position (usually in megabase) of the markers into the sequence}
\item{seq.ref}{reference base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}                 
\item{seq.alt}{alternative base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}
\item{chisq.pval}{a vector containing p-values of the chi-squared test of Mendelian 
                  segregation for all markers in the map}                 
\item{data.name}{name of the dataset of class \code{mappoly.data}}
\item{ph.thres}{the LOD threshold used to define the linkage phase configurations to test}

ii) a list of maps with possible linkage phase configuration. Each map in the list is also a 
   list containing
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{seq.rf}{a vector of size (\code{n.mrk - 1}) containing a sequence of recombination 
              fraction between the adjacent markers in the map}
\item{seq.ph}{linkage phase configuration for all markers in both parents}
\item{loglike}{the hmm-based multipoint likelihood}
}
\description{
Estimates the linkage phase and recombination fraction between pre-built maps 
and creates a new map by merging them.
}
\details{
\code{merge_maps} uses two-point information, under a given LOD threshold, to reduce the 
linkage phase search space. The remaining linkage phases are tested using the genotype 
probabilities.
}
\examples{
\donttest{
#### Tetraploid example #####
map1 <- get_submap(solcap.dose.map[[1]], 1:5)
map2 <- get_submap(solcap.dose.map[[1]], 6:15)
map3 <- get_submap(solcap.dose.map[[1]], 16:30)
full.map <- get_submap(solcap.dose.map[[1]], 1:30)
s <- make_seq_mappoly(tetra.solcap, full.map$maps[[1]]$seq.num)
twopt <- est_pairwise_rf(input.seq = s)
merged.maps <- merge_maps(map.list = list(map1, map2, map3), 
                        twopt = twopt,
                        thres.twopt = 3)
plot(merged.maps, mrk.names = TRUE)                       
plot(full.map, mrk.names = TRUE)                       
best.phase <- merged.maps$maps[[1]]$seq.ph
names.id <- names(best.phase$P)
compare_haplotypes(ploidy = 4, best.phase$P[names.id], 
                   full.map$maps[[1]]$seq.ph$P[names.id]) 
compare_haplotypes(ploidy = 4, best.phase$Q[names.id], 
                   full.map$maps[[1]]$seq.ph$Q[names.id])
}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
