% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordkrige.r
\name{ordkrige}
\alias{ordkrige}
\title{ordkrige}
\usage{
ordkrige(
  x = NULL,
  y = NULL,
  z = NULL,
  field = NULL,
  edge = 0,
  filter = 1,
  resolution = NULL,
  md = "Sph",
  rg = NULL,
  ng = 0.1,
  check.data = TRUE,
  cross.validate = TRUE
)
}
\arguments{
\item{x}{SpatRaster. Required. Must be have a defined Cartesian coordinate 
system. Data must be continuous. If more than one layer, the first layer 
will be used.}

\item{y}{SpatVector of polygons. Optional. Delineates the area within
which the raster layer shall be locally adapted and evaluated. If not provided,
the analyses will be performed within the intersect of the raster and the
sampled area. Must be have a defined Cartesian coordinate system (same as x).}

\item{z}{SpatVector of points Required. Must have at least one column
with numerical data and these data must be of the same entity and unit as x
(specify this column by argument: field). Must be have a defined Cartesian 
coordinate system (same as x).}

\item{field}{Character value. Required. Name of the column in
y with the data that shall be used to locally adapt and evaluate the raster.}

\item{edge}{Numeric value. Optional. Specifies the width (unit of the 
coordinate reference system) of a buffer zone inside the edge of the polygon 
that is excluded from the analyses. Allowed values are within the closed range 
of 0-10000.}

\item{filter}{Positive integer. Optional. No of cells in the side of a square
window for mean filtering of x. Filtering is done before any resampling
(see argument: resolution). Allowed values are within the closed range of 1-20.}

\item{resolution}{Positive numeric value. Optional. The resolution (m) to
which the imported raster shall be resampled before the adaptation. Allowed
values are within the closed range of 0.1-10000. In addition, a resolution that
means more than 1E+8 raster cells is not allowed.}

\item{md}{Character value. Optional. Variogram model type for the standardized
variograms used for ordinary kriging interpolation of observed data or residuals.
Variograms are generated by gstat::vgm. Default is "Sph" (spherical model).}

\item{rg}{Numeric value. Optional. Range of the standardized variograms used
for ordinary kriging interpolation of observed data or residuals. Variograms
are generated by gstat::vgm. If no rg is specified it will be set to half of
the square root of the mapping area: y (possibly shrinked by edge).}

\item{ng}{Numeric value. Optional. Nugget of the standardized variograms
used for ordinary kriging interpolation of observed data or residuals.
Variograms are  generated by gstat::vgm. The nugget is expressed as a fraction
of the sill. A ng = 0.1 means that the nugget is 10 percent of the sill. The sill
is by default equal to the variance of the data to be kriged (i.e the point
observations or the residuals). Allowed values of ng are within the closed
range of 0-1.}

\item{check.data}{Logical value. Default is TRUE. Shall attributes, geometries and projections of
the input data (arguments x, y and z) be checked.}

\item{cross.validate}{Logical value. If TRUE, a leave-one-out cross-validation
is performed}
}
\value{
A list with 1) a raster layer with predicted values and 2) a
SpatVector of points with predictions from a leave-one-out cross-
validation For details, see mri function.
}
\description{
Regression kriging using a standardized variogram.
}
\details{
This is the ordinary kriging function called by the mri function.
It uses a standardized semivariogram model and requires a raster template for which
predictions are made. For details, see documentation of the mri function.
}
