% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncert_masses.R
\name{uncertReading}
\alias{uncertReading}
\title{Uncertainty of balance readings}
\usage{
uncertReading(calibCert, reading, units = NULL, sd = NULL,
  sd.units = NULL, d = NULL, d.units = NULL)
}
\arguments{
\item{calibCert}{object of class \code{"calibCert"} with the calibration
data of the balance. See \code{\link[=calibCert]{calibCert()}} for details.}

\item{reading}{numeric with balance reading for the mass of the object.}

\item{units}{character with the units of \code{reading}. Must be a SI unit.
If not provided, the balance standard units are assumed.
See \code{\link[=calibCert]{calibCert()}} for details.}

\item{sd}{standard deviation when a balance reading is the result
of averaging several individual measurements of same object. If not provided
the information is taken from the calibration certificate of the balance}

\item{sd.units}{character with the units of standard deviation.
If not provided, the value stated at \code{units} or the balance
standard units is used.}

\item{d}{balance division scale. Useful when the balance is operated a a
division scale different from that stated in the calibration certificate.
This is the common case when the user is give up some readability
in order to make faster mass measurements. If not provided.
the functions uses
the balance division scale stated in the calibration certificate.}

\item{d.units}{character with the units of parameter \code{d}.
If not provided, the value stated at \code{units} or the balance
standard units is used.}
}
\value{
A numeric value of uncertainty for a balance reading.
}
\description{
Uncertainty in a given balance reading considering the effects of
rounding error, lack of repeatability, eccentricity and balance taring.
}
\examples{
data(minimalCert)
uncertReading(calibCert = minimalCert, reading = 12.4835)
uncertReading(calibCert = minimalCert, reading = 12.484, d = 1, d.units = 'mg')
}
\seealso{
\code{\link[=uncertErrorCorr]{uncertErrorCorr()}}, \code{\link[=uncertConvMass]{uncertConvMass()}}
}
