% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at.R
\name{at}
\alias{at}
\alias{at<-}
\title{Set or get matrix value at index vector}
\usage{
at(mat, idx)

at(mat, idx) <- value
}
\arguments{
\item{mat}{matrix}

\item{idx}{two-element integer vector}

\item{value}{a value to be assign at index}
}
\value{
`at` function: value from matrix at index idx
}
\description{
This function allows to access matrix values by passing indices as vector
}
\examples{
mat <- matrix(0, 3, 3)
idx <- c(1, 2)
# Typically, given matrix and row-column indices as two-element vector, we should do it like this:
mat[idx[1], idx[2]]
mat[idx[1], idx[2]] <- 8
# Using `at`, we can do it simplier!
at(mat, idx)
at(mat, idx) <- 7
mat
at(mat, idx)
}
