% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc.fcor.R
\name{mc.fcor}
\alias{mc.fcor}
\title{Fisher-transformed Pearson's correlation: Monte Carlo Based Heterogeneity Test for Between-study Heterogeneity in Random- or Mixed- Effects Model}
\usage{
mc.fcor(
  n,
  z,
  model = "random",
  mods = NULL,
  nrep = 10^4,
  p_cut = 0.05,
  mc.include = FALSE
)
}
\arguments{
\item{n}{a vector of sample sizes in each of the included studies.}

\item{z}{a vector of Fisher-transformed Pearson's correlations.}

\item{model}{choice of random- or mixed- effects models. Can only be set to \code{"random"}, or \code{"mixed"}.}

\item{mods}{optional argument to include one or more moderators in the model. \code{mods} is NULL for random-effects model and a dataframe for mixed-effects model. A single moderator can be given as a vector of length \eqn{k} specifying the values of the moderator. Multiple moderators are specified by giving a matrix with \eqn{k} rows and as many columns as there are moderator variables. See \code{\link[metafor:rma.uni]{rma}} for more details.}

\item{nrep}{number of replications used in Monte Carlo Simulations. Default to 10^4.}

\item{p_cut}{cutoff for p-values, which is the alpha level. Default to 0.05.}

\item{mc.include}{if true, Monte Carlo simulation results are included in the output (e.g., Monte Carlo critical values).}
}
\description{
\code{mc.fcor} returns the Monte Carlo based tests of the residual heterogeneity in random- or mixed- effects model of Pearson's correlation coefficients transformed with Fisher's r-to-z transformation (z scores).
}
\details{
This function returns the test statistics as well as their p-value and significances using (1) Q-test, (2) Monte Carlo Based Heterogeneity Test with Maximum Likelihood (ML), and (3) Monte Carlo Based Heterogeneity Test with Restricted Maximum Likelihood (REML).

The results of significances are classified as "sig" or "n.s" based on the cutoff p-value (i.e., alpha level). "sig" means that the between-study heterogeneity is significantly different from zero whereas "n.s" means the between-study heterogeneity is not significantly different from zero. The default alpha level is 0.05.
}
\examples{
# A meta-analysis of 13 studies studying the correlation between sensation
# seeking scores and levels of monoamine oxidase (Zuckerman, 1994).
sensation <- mc.heterogeneity:::sensation
# n is a list of samples sizes
n <- sensation$n
# Pearson's correlation
r <- sensation$r
# Fisher's Transformation
z <- 1/2*log((1+r)/(1-r))
\dontrun{
#' mc.run <- mc.fcor(n, z, model = 'random', p_cut = 0.05)
}
## Note: this mc.fcor() function will soon be deprecated
## and replaced by \link[boot.heterogeneity]{boot.fcor} in
## package [boot.heterogeneity](https://CRAN.R-project.org/package=boot.heterogeneity).
}
\references{
Zuckerman, M. (1994). Behavioral expressions and biosocial bases of sensation seeking. New York, NY: Cambridge University Press.

Viechtbauer, W. (2010). Conducting meta-analyses in R with the metafor package. Journal of Statistical Software, 36(3), 1-48. URL: https://www.jstatsoft.org/v36/i03/
}
