% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccf1.R
\name{autoplot.mccf1}
\alias{autoplot.mccf1}
\title{Plot the MCC-F1 curve}
\usage{
\method{autoplot}{mccf1}(object, xlab = "F1 score", ylab = "normalized MCC",
  ...)
}
\arguments{
\item{object}{S3 object of class "mccf1" from the `mccf1()`}

\item{xlab, ylab}{x- and y- axis annotation (default: "F1 score","normalized MCC")}

\item{...}{further arguments passed to and from method `ggplot()`}
}
\value{
the ggplots object
}
\description{
`autoplot.mccf1()` plots the MCC-F1 curve using ggplot2.
}
\examples{
response <- c(rep(1, 1000), rep(0, 10000))
predictor <- c(rbeta(300, 12, 2), rbeta(700, 3, 4), rbeta(10000, 2, 3))
autoplot(mccf1(response, predictor))
}
