% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ByteCodeMutation}
\alias{ByteCodeMutation}
\title{Mutation operator for byte representation of double values}
\usage{
ByteCodeMutation(bytes1, pmutation)
}
\arguments{
\item{bytes1}{A vector of bytes of a candidate solution}

\item{pmutation}{Probability of mutation}
}
\value{
Byte vector of mutated solution
}
\description{
This function is a C++ wrapper for mutating byte representation of a given candidate solution
}
\examples{
set.seed(1246)
print(pi)
bytes <- DoubleToBytes(pi)
mutated.bytes <- ByteCodeMutation(bytes, 0.10) 
new.var <- BytesToDouble(mutated.bytes)
print(new.var)
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\seealso{
ByteCodeMutationUsingDoubles
}

