% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KO_pathway_ref}
\alias{KO_pathway_ref}
\title{KEGG Orthology (KO) Pathway Information Dataset}
\format{
A data frame with 3846 rows (KO entries) and 10 variables:
\describe{
\item{Orthology_Entry}{Character. KEGG Orthology ID (e.g., "K00844").}
\item{Module_Type}{Character. Type of metabolic module (e.g., "Pathway modules").}
\item{Level_2}{Character. Broad metabolic category (e.g., "Carbohydrate metabolism").}
\item{Level_3}{Character. Specific metabolic subcategory (e.g., "Central carbohydrate metabolism").}
\item{Module_Entry}{Character. KEGG Module ID (e.g., "M00001").}
\item{Module_Name}{Character. Full name of the metabolic module (e.g., "Glycolysis (Embden-Meyerhof pathway), glucose => pyruvate").}
\item{Definition}{Character. KO composition of the module, truncated in display (e.g., "(K00844,K12407,...)").}
\item{Orthology_Symbol}{Character. Short symbol for the KO (e.g., "HK" for hexokinase).}
\item{Orthology_Name}{Character. Full enzyme name with EC number (e.g., "hexokinase \code{[EC:2.7.1.1]}").}
\item{KO_Symbol}{Character. Combined KO ID and symbol (e.g., "K00844; HK").}
}
}
\usage{
KO_pathway_ref
}
\description{
A comprehensive dataset mapping KEGG Orthology (KO) entries to metabolic pathways,
including module hierarchy, definitions, and enzyme annotations.
}
\keyword{datasets}
