% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{as_freqlist}
\alias{as_freqlist}
\title{Coerce table to a frequency list}
\usage{
as_freqlist(x, tot_n_tokens = NULL, sort_by_ranks = TRUE)
}
\arguments{
\item{x}{Object of class \code{table} or named numeric vector that will be
interpreted as such.}

\item{tot_n_tokens}{Number representing the total number of tokens in the
corpus from which the frequency list is derived. When \code{tot_n_tokens}
is \code{NULL}, this total number of tokens will be taken to be the sum
of the frequencies in \code{x}.}

\item{sort_by_ranks}{Logical.
If \code{TRUE}, the items in the frequency list are sorted by frequency
rank. If \code{FALSE}, the items in the frequency list, depending on the
input type, either are sorted alphabetically or are not sorted at all.}
}
\value{
An object of class \code{freqlist}, which is based on the class \code{table}.
It has additional attributes and methods such as:
\itemize{
\item base \code{\link[=print.freqlist]{print()}}, \code{\link[=as_data_frame]{as_data_frame()}},
\code{\link[=summary]{summary()}} and \code{\link[=sort.freqlist]{sort}},
\item \code{\link[tibble:as_tibble]{tibble::as_tibble()}},
\item an interactive \code{\link[=explore]{explore()}} method,
\item various getters, including \code{\link[=tot_n_tokens]{tot_n_tokens()}}, \code{\link[=n_types]{n_types()}}, \code{\link[=n_tokens]{n_tokens()}},
values that are also returned by \code{\link[=summary]{summary()}}, and more,
\item subsetting methods such as \code{\link[=keep_types]{keep_types()}}, \code{\link[=keep_pos]{keep_pos()}}, etc. including \verb{[]}
subsetting (see \link{brackets}).
}

Additional manipulation functions include \code{\link[=type_freqs]{type_freqs()}} to extract the frequencies
of different items, \code{\link[=freqlist_merge]{freqlist_merge()}} to combine frequency lists, and
\code{\link[=freqlist_diff]{freqlist_diff()}} to subtract a frequency list from another.

Objects of class \code{freqlist} can be saved to file with \code{\link[=write_freqlist]{write_freqlist()}};
these files can be read with \code{\link[=read_freqlist]{read_freqlist()}}.
}
\description{
This function coerces an object of class \code{\link{table}} to an object of class \code{\link{freqlist}}.
}
\examples{
toy_corpus <- "Once upon a time there was a tiny toy corpus.
It consisted of three sentences. And it lived happily ever after."

## make frequency list in a roundabout way
tokens <- tokenize(toy_corpus)
flist <- as_freqlist(table(tokens))
flist

## more direct procedure
freqlist(toy_corpus, as_text = TRUE)

## build frequency list from scratch: example 1
flist <- as_freqlist(c("a" = 12, "toy" = 53, "example" = 20))
flist

## build frequency list from scratch: example 2
flist <- as_freqlist(c("a" = 12, "toy" = 53, "example" = 20),
                     tot_n_tokens = 1300)
flist
}
\seealso{
\code{\link[=freqlist]{freqlist()}}
}
