% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpath.R
\name{mclm_xml_text}
\alias{mclm_xml_text}
\title{Get text from xml node}
\usage{
mclm_xml_text(node, trim = FALSE)
}
\arguments{
\item{node}{XML node as read with \code{\link[xml2:read_xml]{xml2::read_xml()}}.}

\item{trim}{If \code{TRUE} will trim leading and trailing spaces.}
}
\value{
Character vector: The text value of the (elements of the) node,
concatenated with spaces in between.
}
\description{
Get text from xml node
}
\examples{
test_xml <- '
<p>
  <w pos="at">The</w>
  <w pos="nn">example</w>
  <punct>.</punct>
</p>'

test_xml_parsed <- xml2::read_xml(test_xml)

# xml2 output
xml2::xml_text(test_xml_parsed)

# mclm version
mclm_xml_text(test_xml_parsed)
}
