% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{merge_freqlist}
\alias{merge_freqlist}
\alias{freqlist_merge}
\alias{freqlist_merge_all}
\title{Merge frequency lists}
\usage{
freqlist_merge(x, y)

freqlist_merge_all(...)
}
\arguments{
\item{x, y}{An object of class \code{\link{freqlist}}.}

\item{...}{Various objects of class \code{\link{freqlist}} or a list of
objects of class \code{\link{freqlist}}.}
}
\value{
An object of class \code{\link{freqlist}}.
}
\description{
These functions merge two or more frequency lists, adding up the frequencies.
In the current implementation, original ranks are lost when merging.
}
\examples{
(flist1 <- freqlist("A first toy corpus.", as_text = TRUE))
(flist2 <- freqlist("A second toy corpus.", as_text = TRUE))
(flist3 <- freqlist("A third toy corpus.", as_text = TRUE))

freqlist_merge(flist1, flist2)

freqlist_merge_all(flist1, flist2, flist3)
freqlist_merge_all(list(flist1, flist2, flist3)) # same result
}
