% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_txt}
\alias{read_txt}
\title{Read a text file into a character vector}
\usage{
read_txt(file, file_encoding = "UTF-8", line_glue = NA, ...)
}
\arguments{
\item{file}{Name of the input file.}

\item{file_encoding}{Encoding of the input file.}

\item{line_glue}{A character vector or \code{NA}. If \code{NA}, the output is a character
vector in which each input line is a separate item, as in \code{\link[readr:read_lines]{readr::read_lines()}}.
Otherwise, the output is a character vector of length 1 in which all input lines
are concatenated, using the value of \code{line_glue[1]} as line separator and as
end-of-last-line marker.}

\item{...}{Additional arguments (not implemented).}
}
\value{
A character vector.
}
\description{
This function reads a text file and returns a character vector containing
the lines in the text file.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
x <- "This is
a small
text."

# write the text to a text file
write_txt(x, "example-text-file.txt")
# read a text from file
y <- read_txt("example-text-file.txt")
y
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=write_txt]{write_txt()}}

Other reading functions: 
\code{\link{read_assoc}()},
\code{\link{read_conc}()},
\code{\link{read_fnames}()},
\code{\link{read_freqlist}()},
\code{\link{read_tokens}()},
\code{\link{read_types}()}
}
\concept{reading functions}
