% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.R
\name{write_freqlist}
\alias{write_freqlist}
\title{Write a frequency list to a csv file}
\usage{
write_freqlist(x, file, sep = "\\t", make_config_file = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{\link{freqlist}}.}

\item{file}{Character vector of length 1. Path to the output file.}

\item{sep}{Character vector of length 1. Column separator.}

\item{make_config_file}{Logical. Whether or not a configuration file
needs to be created. In most circumstances, this should be set to \code{TRUE}.}

\item{...}{Additional arguments (not implemented).}
}
\value{
Invisibly, \code{x}.
}
\description{
This function writes an object of the class \code{\link{freqlist}} to a csv file. The
resulting csv file contains two columns, the first being the type and the
second being the frequency of that type. The file also contains
a header line with the names of both columns.
}
\details{
\code{write_freqlist} not only writes to the file \code{file},
but also creates a configuration file with a name that
is identical to \code{file}, except that it has the filename extension
\code{".yaml"}. The frequency list attributes \code{"tot_n_tokens"}
and \code{"tot_n_types"} are stored to that configuration file.
}
\examples{
toy_corpus <- "Once upon a time there was a tiny toy corpus.
It consisted of three sentences. And it lived happily ever after."
freqs <- freqlist(toy_corpus, as_text = TRUE)

print(freqs, n = 1000)
\dontshow{.old_wd <- setwd(tempdir())}
write_freqlist(freqs, "example_freqlist.csv")
freqs2 <- read_freqlist("example_freqlist.csv")
print(freqs2, n = 1000)
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=read_freqlist]{read_freqlist()}}

Other writing functions: 
\code{\link{write_assoc}()},
\code{\link{write_conc}()},
\code{\link{write_fnames}()},
\code{\link{write_tokens}()},
\code{\link{write_txt}()},
\code{\link{write_types}()}
}
\concept{writing functions}
