% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{VCAinference}
\alias{VCAinference}
\title{Inferential Statistics for VCA-Results}
\usage{
VCAinference(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[VCA:VCAinference]{VCA::VCAinference}}
  \describe{
    \item{\code{obj}}{(object) of class 'VCA' or, alternatively, a list of 'VCA' objects, where all other arguments can be 
specified as vectors, where the i-th vector element applies to the i-th element of 'obj' (see examples)}
    \item{\code{alpha}}{(numeric) value specifying the significance level for \eqn{100*(1-alpha)}\% confidence intervals.}
    \item{\code{total.claim}}{(numeric) value specifying the claim-value for the Chi-Squared test for the total variance (SD or CV, see \code{claim.type}).}
    \item{\code{error.claim}}{(numeric) value specifying the claim-value for the Chi-Squared test for the error variance (SD or CV, see \code{claim.type}).}
    \item{\code{claim.type}}{(character) one of "VC", "SD", "CV" specifying how claim-values have to be interpreted:\cr
"VC" (Default) = claim-value(s) specified in terms of variance(s),\cr
"SD" = claim-values specified in terms of standard deviations (SD),\cr
"CV" = claim-values specified in terms of coefficient(s) of variation (CV)
and are specified as percentages.\cr
If set to "SD" or "CV", claim-values will be converted to variances before applying the Chi-Squared test (see examples).}
    \item{\code{VarVC}}{(logical) TRUE = the covariance matrix of the estimated VCs will be computed (see \code{\link[VCA]{vcovVC}}), where diagonal
    elements correspond to the variances of the individual VCs. This matrix is required for estimation of CIs for 
intermediate VCs if 'method.ci="sas"'. 
FALSE (Default) = computing covariance matrix of VCs is omitted, as well as CIs for intermediate VCs.}
    \item{\code{excludeNeg}}{(logical) TRUE = confidence intervals of negative variance estimates will not be reported. \cr
FALSE = confidence intervals for all VCs will be reported including those with negative VCs.\cr
See the details section for a thorough explanation.}
    \item{\code{constrainCI}}{(logical) TRUE = CI-limits for all variance components are constrained to be >= 0.\cr
FALSE = unconstrained CIs with potentially negative CI-limits will be reported.\cr
which will preserve the original width of CIs.
See the details section for a thorough explanation.}
    \item{\code{ci.method}}{(character) string or abbreviation specifying which approach to use for computing confidence intervals of variance components (VC).
"sas" (default) uses Chi-Squared based CIs for total and error and normal approximation for all other VCs (Wald-limits, option "NOBOUND"
in SAS PROC MIXED); "satterthwaite" will approximate DFs for each VC using the Satterthwaite approach (see \code{\link[VCA]{SattDF}} for models
fitted by ANOVA) and all Cis are based on the Chi-Squared distribution. This approach is conservative but avoids negative values for the lower bounds.}
    \item{\code{quiet}}{(logical) TRUE = will suppress any warning, which will be issued otherwise}
  }}
}
\value{
object of \code{VCAinference} contains a series of statistics.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A copy from \link[VCA:VCAinference]{VCA::VCAinference} in \code{VCA} package
}
\examples{
data(glucose)
fit <- anovaVCA(value ~ day / run, glucose)
VCAinference(fit)
}
\seealso{
\code{\link[VCA:VCAinference]{VCA::VCAinference()}}
}
