% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_relative_bias}
\alias{calc_relative_bias}
\title{Calculate Relative Bias and its Monte Carlo Standard Error}
\usage{
calc_relative_bias(estimates, true_param)
}
\arguments{
\item{estimates}{A numeric vector of estimates from a simulation or sampling process.}

\item{true_param}{The true parameter value that the estimates are intended to approximate.
Note that `true_param` must not be zero, as relative bias calculation involves division by
the true parameter value.}
}
\value{
A list with two components: `rel_bias`, the calculated relative bias of the estimates, and
`rel_bias_mcse`, the Monte Carlo Standard Error of the relative bias. If `true_param` is zero,
both `rel_bias` and `rel_bias_mcse` will be `NA`.
}
\description{
Computes the relative bias of a set of estimates with respect to a true parameter value,
along with the Monte Carlo Standard Error (MCSE) of the relative bias. Relative bias is
the ratio of the mean of the estimates to the true parameter, providing a scale-independent
measure of bias. This function is particularly useful for evaluating the accuracy of estimates
in situations where the magnitude of the true parameter is crucial to the interpretation of bias.
The function gracefully handles cases where the true parameter is zero by returning `NA` for
both relative bias and its MCSE, avoiding division by zero errors.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
true_param <- 50 # Non-zero true parameter
relative_bias_info <- calc_relative_bias(estimates, true_param)
print(relative_bias_info)
}
