% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdi.R
\name{cdi}
\alias{cdi}
\title{Item, attribute, and test-level discrimination indices}
\usage{
cdi(model, weight_prevalence = TRUE)
}
\arguments{
\item{model}{The estimated model to be evaluated.}

\item{weight_prevalence}{Logical indicating whether the discrimination
indices should be weighted by the prevalence of the attribute profiles. See
details for additional information.}
}
\value{
A list with two elements:
\itemize{
\item \code{item_discrimination}: A \link[tibble:tibble-package]{tibble} with one row
per item containing the \acronym{CDI} for the item and any relevant
attributes.
\item \code{test_discrimination}: A \link[tibble:tibble-package]{tibble} with one row
containing the total \acronym{CDI} for the assessment and for each
attribute.
}
}
\description{
The cognitive diagnostic index (\acronym{CDI}) is a measure of how well an
assessment is able to distinguish between attribute profiles.
The index was originally proposed by Henson & Douglas (2005) for item- and
test-level discrimination, and then expanded by Henson et al. (2008) to
include attribute-level discrimination indices.
}
\details{
Henson et al. (2008) described two attribute-level discrimination indices,
\eqn{\mathbf{d}_{(A)\mathbf{\cdot}}} (Equation 8) and
\eqn{\mathbf{d}_{(B)\mathbf{\cdot}}} (Equation 13), which are similar in that
both are the sum of item-level discrimination indices.
In both cases, item-level discrimination indices are calculated as the
average of Kullback-Leibler information for all pairs of attributes profiles
for the item.
The item-level indices are then summed to achieve the test-level
discrimination index for each attribute, or the test overall.
However, whereas \eqn{\mathbf{d}_{(A)\mathbf{\cdot}}} is an unweighted
average of the Kullback-Leibler information,
\eqn{\mathbf{d}_{(B)\mathbf{\cdot}}} is a weighted average, where the weight
is defined by the prevalence of each profile (i.e.,
\code{\link[=measr_extract]{measr_extract(model, what = "strc_param")}}).
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
rstn_ecpe_lcdm <- dcm_estimate(
  dcm_specify(dcmdata::ecpe_qmatrix, identifier = "item_id"),
  data = dcmdata::ecpe_data,
  missing = NA,
  identifier = "resp_id",
  method = "optim",
  seed = 63277,
  backend = "rstan"
)

cdi(rstn_ecpe_lcdm)
\dontshow{\}) # examplesIf}
}
\references{
Henson, R., & Douglas, J. (2005). Test construction for cognitive
diagnosis. \emph{Applied Psychological Measurement, 29}(4), 262-277.
\doi{10.1177/0146621604272623}

Henson, R., Roussos, L., Douglas, J., & Xuming, H. (2008).
Cognitive diagnostic attribute-level discrimination indices.
\emph{Applied Psychological Measurement, 32}(4), 275-288.
\doi{10.1177/0146621607302478}
}
