% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{haemoglobin_ext}
\alias{haemoglobin_ext}
\title{Haemoglobin external data [external outcome-validation study]}
\format{
A data frame with 100 rows and 2 variables:
\describe{
  \item{capillary}{Haemoglobin levels measured in capillary blood (g/L)}
  \item{venous}{Haemoglobin levels measured in venous blood (g/L)}
}
}
\usage{
haemoglobin_ext
}
\description{
Capillary haemoglobin and venous haemoglobin levels of 100 individuals.
}
\details{
This is a simulated data set accompanying the dataset "haemoglobin", that is inspired by a trial investigating low-dose iron supplements <doi:10.1093/ajcn/78.1.145>. A motivating example using the example data can be found here: <doi:10.1002/sim.8359>
}
\examples{
data("haemoglobin_ext", package = "mecor")
}
\references{
Maria Makrides, Caroline A Crowther, Robert A Gibson, Rosalind S Gibson, and C Murray Skeaff. Efficacy and tolerability of low-dose iron supplements during pregnancy: a randomized controlled trial. The American Journal of Clinical Nutrition (2003). <doi:10.1093/ajcn/78.1.145>

Linda Nab, Rolf HH Groenwold, Paco MJ Welsing, and Maarten van Smeden. Measurement error in continuous endpoints in randomised trials: Problems and solutions. Statistics in Medicine (2019). <doi:10.1002/sim.8359>
}
\keyword{datasets}
