% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elixhauser_poa.R
\name{get_elixhauser_poa}
\alias{get_elixhauser_poa}
\title{Get Elixhauser Present-on-Admission Requirements}
\usage{
get_elixhauser_poa()
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{condition}: Character vector of the conditions
\item \code{desc}: Character vector with a verbose description of the condition
\item \code{poa_required}: Integer indicators if the code needs to present on admission to be considered a comorbidity
\item \verb{elixhauser_<variant>}: indicators for the Elixhauser \verb{<variant>}
}
}
\description{
Retrieve a copy of internal lookup table with details on which Elixhauser
comorbidities do and do not require the associated ICD codes to be
present-on-admission to be flagged.
}
\examples{
head(get_elixhauser_poa())
str(get_elixhauser_poa())

}
\seealso{
\itemize{
\item \code{\link[=get_elixhauser_index_scores]{get_elixhauser_index_scores()}} for the lookup table of the condition by
condition scores for mortality and readmission indices.
\item \code{\link[=get_elixhauser_codes]{get_elixhauser_codes()}} for the lookup table of ICD codes mapping to the
Elixhauser comorbidities.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
