% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-pro.R
\name{get_pro}
\alias{get_pro}
\alias{get_pro_groups}
\alias{get_pro_events}
\title{Retrieve information about Meetup Pro networks,
including groups and events.}
\usage{
get_pro_groups(
  urlname,
  max_results = NULL,
  handle_multiples = "list",
  extra_graphql = NULL,
  asis = FALSE,
  ...
)

get_pro_events(
  urlname,
  status = NULL,
  date_before = NULL,
  date_after = NULL,
  max_results = NULL,
  handle_multiples = "list",
  extra_graphql = NULL,
  asis = FALSE,
  ...
)
}
\arguments{
\item{urlname}{Character. The name of the group as indicated in the
\url{https://www.meetup.com/} url.}

\item{max_results}{Maximum number of results to return. If set to NULL,
will return all available results (may take a long time).}

\item{handle_multiples}{Character. How to handle multiple matches. One of
"list" or "first", or "error".
If "list", return a list-column with all matches.
If "first", return only the first match.}

\item{extra_graphql}{A graphql object. Extra objects to return}

\item{asis}{Return the raw API response as-is without processing}

\item{...}{Should be empty. Used for parameter expansion}

\item{status}{Which status the events should have.}

\item{date_before}{Datetime string in "YYYY-MM-DDTHH:MM:SSZ" (ISO8601) format. Events occurring before this date/time will be returned.}

\item{date_after}{Datetime string in "YYYY-MM-DDTHH:MM:SSZ" (ISO8601) format. Events occurring after this date/time will be returned.}
}
\value{
tibble with pro network information

A tibble with meetup pro information
}
\description{
Meetup Pro is a premium service for organizations
managing multiple Meetup groups.
This functionality allows you to access details about
the groups within a Pro network
and the events they host.
}
\section{Functions}{
\itemize{
\item \code{get_pro_groups()}: retrieve groups in a pro network

\item \code{get_pro_events()}: retrieve events from a pro network

}}
\examples{
\dontshow{
vcr::insert_example_cassette("get_pro", package = "meetupr")
meetupr:::mock_if_no_auth()
}
urlname <- "rladies"
members <- get_pro_groups(urlname)

upcoming_events <- get_pro_events(urlname, "upcoming", max_results = 5)
\dontshow{
vcr::eject_cassette()
}
}
