% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfcorrect.R
\name{sampleResponse}
\alias{sampleResponse}
\title{Sample more solutions when non-executable code returned by the agent}
\usage{
sampleResponse(
  agent,
  prompt,
  context = rbionfoExp,
  attempts = 3,
  output.file = NULL,
  responseWithError = NULL,
  ...
)
}
\arguments{
\item{agent}{An object containing the agent's information (e.g., type and model).}

\item{prompt}{The prompt text to send to the language model.}

\item{context}{Optional context to provide alongside the prompt (default is rbionfoExp).}

\item{attempts}{Numeric value denoting how many times the code should be sent back for fixing.}

\item{output.file}{Optional output file created holding parsed code}

\item{responseWithError}{a list of response and errors returned from executeCode().
First element is expected to be the response and the second element is the error list returned by executeCode().}

\item{...}{Additional arguments to be passed to the \code{\link{sendPrompt}} function.}
}
\value{
A list containing the following elements:
\item{init.response}{A character vector representing the initial prompt response.}
\item{init.blocks}{A list of initial blocks.}
\item{final.blocks}{A list of final blocks.}
\item{code.works}{A boolean value indicating whether the code works.}
\item{exec.result}{A character string representing the execution results.}
\item{tried.attempts}{An integer representing the number of attempts.}
}
\description{
The function attempts to sample more solutions by the agent when
the code returned by the agent is faulty. The function simply asks for solutions
until an executable code is returned or until number of attempts is reached.
}
\examples{
\dontrun{

resp.list <- sampleResponse(agent,prompt,context=rbionfoExp, max_tokens = 500)
}
}
\seealso{
\code{\link{promptContext}} for predefined contexts to use.
}
