% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupAgent.R
\name{setupAgent}
\alias{setupAgent}
\title{set up an online LLM API for subsequent tasks}
\usage{
setupAgent(
  name = c("openai", "replicate", "generic"),
  type = NULL,
  model = NULL,
  url = NULL,
  ai_api_key = Sys.getenv("AI_API_KEY")
)
}
\arguments{
\item{name}{A string for the name of the API, one of "openai", "replicate" or "generic".
Currently supported APIs are "openai" and "replicate". If the user wishes to use
another API that has similar syntax to openai API this is also supported via the
the "generic" option. In this case, the user should also provide a url for the API
using the}

\item{type}{Specify type of model (chat or completion). This parameter only needs to be specified when using 'openai}

\item{model}{LLM model you wish to use.
For openAI chat model examples are:
\itemize{
\item 'gtp-3-5-turbo'
\item 'gtp-4'}
For openAI completion models examples are:
\itemize{
\item 'text-curie-001'
\item 'text-davinci-002'}
For replicate models examples are:\itemize{
 \item llama-2-70b-chat ( as '02e509c789964a7ea8736978a43525956ef40397be9033abf9fd2badfe68c9e3')
 \item llama-2-13b-chat ( as 'f4e2de70d66816a838a89eeeb621910adffb0dd0baba3976c96980970978018d')}
 For a full list of openAI models see
 https://platform.openai.com/docs/models/overview/. For a full list of Replicate models,
 see https://replicate.com/collections/language-models.}

\item{url}{the url for the API in case the API "generic" is selected. (Default: NULL)}

\item{ai_api_key}{personal API key for accessing LLM}
}
\value{
A list holding agent information.
}
\description{
This function sets up an large language model API for tasks.
}
\examples{
{
myAgent <- setupAgent(name="openai",type="chat",model="gpt-4",ai_api_key="my_key")

myAgent <- setupAgent(name="replicate",type=NULL,
                     model="02e509c789964a7ea8736978a43525956ef40397be9033abf9fd2badfe68c9e3",
                     ai_api_key="my_key")
}
}
