% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_spectrum}
\alias{plot_spectrum}
\title{Plot Spectrum}
\usage{
plot_spectrum(
  x,
  ...,
  obj = as_v12_singlet(x),
  foc_frac = get_foc_frac(obj),
  foc_rgn = get_foc_rgn(obj, foc_frac),
  sub1 = TRUE,
  sub2 = FALSE,
  sub3 = width(foc_rgn) < width(obj$cs),
  mar = NULL,
  frame = FALSE,
  con_lines = TRUE
)
}
\arguments{
\item{x}{An object of type \code{spectrum}, \code{decon0}, \code{decon1}, \code{decon2} or \code{align}. For
details see \href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes}.}

\item{...}{Additional arguments passed to \code{\link[=draw_spectrum]{draw_spectrum()}} for \strong{every} sub figure.
See 'Details'.}

\item{obj}{An object of type \code{spectrum} or \code{decon2}. Usually auto  generated  from  \code{x},
but can be set manually in case the default conversion is not sufficient.}

\item{foc_frac}{A numeric vector specifying the start and end of the focus region as fraction
of the full spectrum width. Only used if \code{foc_rgn} is set to NULL.}

\item{foc_rgn}{A numeric vector specifying the start and end of the focus region in ppm.  If
set to NULL, \code{foc_frac} is used  to  determine  the  focus  region.  If  both
\code{foc_rgn}  and  are  set  to  NULL,  a  suitable  focus  region  is   chosen
automatically. Takes precedence over \code{foc_frac}.}

\item{sub1, sub2, sub3}{List of arguments passed to \code{\link[=draw_spectrum]{draw_spectrum()}} when drawing sub figure
1-3. See 'Details'.}

\item{mar}{A numeric vector of length 4 specifying the margins of the plot. Passed to
\code{\link[=par]{par()}}. If set to \code{NULL}, a suitable value is chosen automatically.}

\item{frame}{A list of values passed to \code{\link[=box]{box()}} when drawing the frame around plot region.
If set to \code{NULL}, no frame is drawn.}

\item{con_lines}{A list of values passed to \code{\link[=lines]{lines()}} when drawing the connecting lines between
sub figure 1 and the focus rectangle in sub figure 3. See 'Details'.
If set to \code{NULL}, the connecting lines are not drawn.}
}
\value{
NULL. Called for side effect of plotting as sketched in 'Details'.
}
\description{
Plot a spectrum and zoom in on a specific region.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This function first initializes a new plotting canvas.  After  that  it  calls
\code{\link[=draw_spectrum]{draw_spectrum()}} multiple times to draw the following sub figures  onto  the
plotting canvas:
\enumerate{
\item The signal intensities in the focus region
\item The second derivative in the focus region
\item The signal intensities over all datapoints
}

The  argument  lists  for  the  individual  calls  to  \code{\link[=draw_spectrum]{draw_spectrum()}}  are
determined at runtime and depend on the arguments passed to \code{\link[=plot_spectrum]{plot_spectrum()}}
as well as the currently active graphics device. To customize the  appearance
of the  individual  sub  plots,  you  can  overwrite  each  value  passed  to
\code{\link[=draw_spectrum]{draw_spectrum()}} by providing  a  corresponding  named  element  in  \code{sub1},
\code{sub2} or \code{sub3}.

A sketch of the resulting figure is shown below.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ __________________________________________
|        ______________1_____________      |
|       | Sub1: Signal Intensity in  |     |
|       | Focus Region               |     |
|       |             /\\             |     |
|       |            /  \\            |     |
|       |           /    \\  /\\       |     |
|     11|          /      \\/  \\      |7    |
|       |     /\\  /            \\     |     |
|       |    /  \\/              \\    |     |
|       |   /                    \\   |     |
|       |__/___________0__________\\__|     |
|       | Sub2: Second Derivative    |     |
|     11| in Focus Region            |7    |
|       |____________________________|     |
|                      3                   |
|    __________________3_________________  |
|   |  Sub3: Signal Intensity over all   | |
|   |  Datapoints     ________________   | |
| 5 |                | Focus Rectangle|  |1|
|   |     /\\         |       /\\       |  | |
|   |    /  \\        |      /  \\/\\    |  | |
|   |   /    \\   /\\  |   /\\/      \\   |  | |
|   |__/______\\_/__\\_|__/__________\\__|__| |
|______________________5___________________|
}\if{html}{\out{</div>}}

Note  that  the  figure  created  by  \code{plot_spectrum()}  can  be  part  of  a
multi-figure configuration as created when setting  \code{mfrow}  or  \code{mfcol}  via
\code{\link[=par]{par()}}. Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{_______________________________________
| Plot Spectrum with   | Other Figure  |
| sub3 = TRUE          | Other Figure  |
|      ___________     |  ___________  |
|     | Sub Fig 1 |    | | x      x  | |
|     |___________|    | |      x    | |
|     |_Sub_Fig_2_|    | |      x    | |
|   _________________  | |   x     x | |
|  |    Sub Fig 3    | | |      x    | |
|  |_________________| | |___________| |
|______________________|_______________|
| Some other Figure    | Plot Spectrum |
|                      | sub3 = FALSE  |
|  _________________   |  ___________  |
| |     ___         |  | | Sub Fig 1 | |
| | ___/   \\___     |  | |           | |
| |/           \\____|  | |___________| |
| |                 |  | | Sub Fig 2 | |
| |_________________|  | |___________| |
|______________________|_______________|
}\if{html}{\out{</div>}}
}
\examples{
## 1. Prepare a deconvoluted spectrum as input

spec <- read_spectrum(metabodecon_file("sim/sim_01"))
decon <- generate_lorentz_curves_sim(spec)

## 2.1. Plot the full (non-deconvoluted) spectrum
## 2.2. Remove connecting lines, and focus on a specific region specified in ppm
## 2.3. Show second derivative and focus on a specific region specified as fraction
## 2.4. Change color of focus rectangle and margins of sub figure 1
## 2.5. Hide xlab and show second derivative
## 2.6. Change the figure region for sub figure 1

plot_spectrum(spec, sub1 = FALSE)
plot_spectrum(decon, foc_rgn = c(3.49, 3.45), con_lines = FALSE)
plot_spectrum(decon, sub2 = TRUE, foc_frac = c(0.40, 0.30))
plot_spectrum(decon,
    sub1 = list(mar = c(3, 6, 3, 6), lt_axis = list(col = "violet")),
    foc_rect = list(border = "violet", col = transp("violet")),
    con_lines = list(col = "violet")
)
plot_spectrum(decon,
    sub2 = TRUE,
    sub3 = list(bt_text = list(text = "")),
    frame = TRUE,
    con_lines = FALSE
)
plot_spectrum(decon, sub1 = list(fig_rgn_npc = c(0,1,.3,1), mar = c(0,5,0,0)))

}
\author{
2024-2025 Tobias Schmidt: initial version.
}
