% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CS.Algorithm.R
\name{CS}
\alias{CS}
\title{Optimization using Cuckoo Search algorithm}
\usage{
CS(FUN, optimType = "MIN", numVar, numPopulation = 40, maxIter = 500,
  rangeVar, abandonedFraction = 0.5)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{abandonedFraction}{a positive numeric between 0 and 1 to determine fraction
of population to be replaced. The default value is 0.5.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements cuckoo search
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Yang & Deb, 2009). This
algorithhm was inspired by behaviour of cuckoo birds which
place its egg on other bird nest. While cuckoo birds putting
the eggs in the nests of other birds they are two possible
outcome. First the owner of the nest will stay on the nest.
Second the owner of the nest will abandon the nest.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item create a mutant vector.
\item select a candidate solution in population randomly then compare it with mutant vector.
      if mutant vector have better fitness than candidate solution replace candidate solution with
      mutant vector.
\item replace fraction of population with worst fitness with new random candidate solutions.
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to create a mutant vector.
}
}
\examples{
##################################
## Optimizing the sphere function

# define sphere function as objective function
sphere <- function(x){
    return(sum(x^2))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution cuckoo search
resultCS <- CS(sphere, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using sphere function
optimum.value <- sphere(resultCS)

}
\references{
Yang, X. S., & Deb, S. (2009, December). Cuckoo search via Lévy flights. In 2009 World Congress on
Nature & Biologically Inspired Computing (NaBIC) (pp. 210-214). IEEE.
}
\seealso{
\code{\link{metaOpt}}
}
