% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSO.Algorithm.R
\name{CSO}
\alias{CSO}
\title{Optimization using Cat Swarm Optimization Algorithm}
\usage{
CSO(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar, mixtureRatio = 0.5, tracingConstant = 0.1,
  maximumVelocity = 1, smp = as.integer(20), srd = 20,
  cdc = as.integer(numVar), spc = TRUE)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}

\item{mixtureRatio}{a positive numeric between 0 and 1 to determine flaging proportion.
higher mixtureRatio increase number of candidate solutions in seeking mode
and vice versa. The default value is 0.5.}

\item{tracingConstant}{a positive numeric between 0 and 1 to determine tracingConstant. The default value is 0.1.}

\item{maximumVelocity}{a positive numeric to determine maximumVelocity while candidate solutions
in tracing mode performing local search. The default value is 1.}

\item{smp}{a positive integer to determine number of duplication in genetic operator. The default value is \code{as.integer(20)}.}

\item{srd}{a positive numeric between 0 and 100 to determine mutation length in genetic operator. The default value is 20.}

\item{cdc}{a positive integer between 0 and numVar to determine number of variabel in
candidate solutions in seeking mode to be mutated during mutation step in
genetic operator. The default value is \code{as.integer(numVar)}.}

\item{spc}{a logical. if spc is TRUE smp = smp else smp = smp - 1.  The default value is TRUE.}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Cat Swarm Optimization
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Chu, Tsai & Pan, 2006).
This algorithm was inspired by behaviours of felyne. Behaviours of
felyne can be devided into two seeking mode (when flyne rest)
and tracing mode (when felyne chase its prey). candidate solutions divided
into seeking and tracing mode. candidate solution in seeking mode move using
local search while candidate solution in tracing mode move using genetic operator.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item initialize population randomly.
\item flaging (tracing or seeking) every candidate solution in population based on mixtureRatio randomly.
\item candidate solutions in seeking mode move using local search
\item candidate solutions in tracing mode move using genetic operator
\item If a termination criterion (a maximum number of iterations or a sufficiently good fitness) is met,
      exit the loop, else back to flaging candidate solutions.
}
}
\examples{
##################################
## Optimizing the schewefel's problem 2.22 function

# define schewefel's problem 2.22 function as objective function
schewefels2.22 <- function(x){
   return(sum(abs(x)+prod(abs(x))))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Ant Lion Optimizer
resultCSO <- CSO(schewefels2.22, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using schewefel's problem 2.22 function
optimum.value <- schewefels2.22(resultCSO)

}
\references{
Chu, S. C., Tsai, P. W., & Pan, J. S. (2006, August). Cat swarm optimization.
In Pacific Rim international conference on artificial intelligence (pp. 854-858).
Springer, Berlin, Heidelberg.
}
\seealso{
\code{\link{metaOpt}}
}
