% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_example_exploration.R
\name{meta_example_exploration}
\alias{meta_example_exploration}
\title{Create a data exploration \code{meta_adam} object}
\usage{
meta_example_exploration(
  data,
  group,
  name = "ase",
  subset = NULL,
  label = "All Subjects Enrolled"
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A character vector of group variable names in an ADaM dataset.}

\item{name}{A character value of term name.
The term name is used as key to link information.}

\item{subset}{An expression to identify analysis records.
See \code{\link[base:subset]{base::subset()}}.}

\item{label}{A character value of analysis label.}
}
\value{
A metadata object.
}
\description{
Create a data exploration \code{meta_adam} object
}
\examples{
meta <- meta_example_exploration(r2rtf::r2rtf_adsl, group = "TRT01A")
collect_n_subject(meta, "ase", "AGE")
collect_n_subject(meta, "ase", "SEX")
}
