% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metamer-package.R
\docType{package}
\name{metamer-package}
\alias{metamer}
\alias{metamer-package}
\title{metamer: Create Data with Identical Statistics}
\description{
Creates data with identical statistics (metamers) using an iterative algorithm proposed by Matejka & Fitzmaurice (2017) \doi{10.1145/3025453.3025912}.
}
\section{Overview}{

Create metamers with the \code{\link[=metamerize]{metamerize()}} function.

Some helper functions included:
\itemize{
\item \code{\link[=draw_data]{draw_data()}} for drawing 2D datasets by hand and \code{\link[=densify]{densify()}} for increasing
the point density of those drawings.
\item \code{\link[=delayed_with]{delayed_with()}} for defining statistics to preserve.
\item \code{\link[=moments_n]{moments_n()}} for preserving moments of order n.
\item \code{\link[=mean_dist_to]{mean_dist_to()}} for minimizing the mean distance to a known target dataset.
}

The \code{\link[=as.data.frame]{as.data.frame()}}/\verb{[data.table::as.data.table()] methods included will turn a }metamer_list` into a tidy
data.frame.

Inspired by Matejka & Fitzmaurice (2017) awesome paper.
}

\references{
Matejka, J., & Fitzmaurice, G. (2017). Same Stats, Different Graphs. Proceedings of the 2017 CHI Conference on Human Factors in Computing Systems  - CHI ’17, 1290–1294. https://doi.org/10.1145/3025453.3025912
}
\seealso{
Useful links:
\itemize{
  \item \url{https://eliocamp.github.io/metamer/}
  \item Report bugs at \url{https://github.com/eliocamp/metamer/issues}
}

}
\author{
\strong{Maintainer}: Elio Campitelli \email{elio.campitelli@cima.fcen.uba.ar} (\href{https://orcid.org/0000-0002-7742-9230}{ORCID})

}
\keyword{internal}
