% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.compare.R
\name{alpha.compare}
\alias{alpha.compare}
\title{Compare multiple alpha diversity indexes between groups}
\usage{
alpha.compare(
  datlist,
  depth,
  mapfile,
  mapsampleid,
  comvar,
  adjustvar,
  personid = "personid",
  longitudinal = "yes",
  age.limit = 1e+06,
  standardize = FALSE
)
}
\arguments{
\item{datlist}{the list of your dataframe.}

\item{depth}{the rarefaction depth of choice. Depth can be "max" (highest depth) or an order (number) of the depth in the list generated by alpha_rarefaction.py}

\item{mapfile}{mapping file}

\item{mapsampleid}{sample id in the mapping file}

\item{comvar}{variable for comparison}

\item{adjustvar}{variables that need to be adjusted in the model}

\item{personid}{name of variable for person id. Default is "personid" (applicable when longitudinal="yes").}

\item{longitudinal}{longitudinal data or one time data. Options are c("yes","no"). Default is "yes".}

\item{age.limit}{age upper limit for included samples. Default is 1000000 months (~no upper limit).}

\item{standardize}{standardization of diversity indexes before comparison or not. Default is FALSE.}
}
\value{
list of comparison result matrices and mean diversity of all indexes for each samples (with or without standardization)
}
\description{
This function calculates average of alpha diversity indexes for a specific rarefaction depth, standardize diversity indexes and compare between groups
using linear/linear mixed effect model and adjust for covariates.
}
\examples{
data(alphadat)
data(covar.rm)
covar.rm$sampleid<-tolower(covar.rm$sampleid)
#comparison of standardized alpha diversity indexes between genders adjusting for
#breastfeeding and infant age at sample collection in infants <=6 months of age
alphacom<-alpha.compare(datlist=alphadat,depth=3,mapfile=covar.rm,
mapsampleid="sampleid", comvar="gender",adjustvar=c("age.sample","bf"),
longitudinal="yes", age.limit=6,standardize=TRUE)
alphacom$alphasum[,1:5]
}
\keyword{alpha}
\keyword{comparison}
\keyword{diversity}
