% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMMI_indexes.R
\name{ammi_indexes}
\alias{ammi_indexes}
\title{AMMI-based stability indexes}
\usage{
ammi_indexes(.data, order.y = NULL, level = 0.95)
}
\arguments{
\item{.data}{An object of class \code{waas} or \code{performs_ammi}}

\item{order.y}{A vector of the same length of \code{x} used to order the
response variable. Each element of the vector must be one of the \code{'h'}
or \code{'l'}. If \code{'h'} is used, the response variable will be ordered
from maximum to minimum. If \code{'l'} is used then the response variable
will be ordered from minimum to maximum. Use a comma-separated vector of
names. For example, \code{order.y = c("h, h, l, h, l")}.}

\item{level}{The confidence level. Defaults to 0.95.}
}
\value{
A list where each element contains the result AMMI-based stability indexes
for one variable.
}
\description{
\itemize{
\item \code{ammi_indexes()} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} computes several AMMI-based stability statistics. See
\strong{Details} for a detailed overview.
\item \code{AMMI_indexes()} \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use \code{ammi_indexes()} instead.
}
}
\details{
First, let's define some symbols: \mjseqn{N'} is the number of significant
interation principal component axis (IPCs) that were retained in the AMMI
model via F tests); \mjseqn{\lambda_{n}} is the singular value for th IPC and
correspondingly \mjseqn{\lambda_{n}^{2}} its eigen value; \mjseqn{\gamma_{in}}
is the eigenvector value for ith genotype; \mjseqn{\delta_{jn}} is the
eigenvector value for the th environment. \mjseqn{PC_{1}}, \mjseqn{PC_{2}},
and \mjseqn{PC_{n}} are the scores of 1st, 2nd, and nth IPC; respectively;
\mjseqn{\theta_{1}}, \mjseqn{\theta_{2}}, and \mjseqn{\theta_{n}}  are
percentage sum of squares explained by the 1st, 2nd, and nth IPC,
respectively.

\loadmathjax
\itemize{
\item AMMI Based Stability Parameter (ASTAB) (Rao and Prabhakaran 2005).
\mjsdeqn{ASTAB = \sum_{n=1}^{N'}\lambda_{n}\gamma_{in}^{2}}
\item AMMI Stability Index (ASI) (Jambhulkar et al. 2017)
\mjsdeqn{ASI = \sqrt{\left [ PC_{1}^{2} \times \theta_{1}^{2} \right ]+\left[ PC_{2}^{2} \times \theta_{2}^{2} \right ]}}
\item AMMI-stability value (ASV) (Purchase et al., 2000).
\mjsdeqn{ASV_{i}=\sqrt{\frac{SS_{IPCA1}}{SS_{IPCA2}}(\mathrm{IPC} \mathrm{A} 1)^{2}+(\mathrm{IPCA} 2)^{2}}}
\item Sum Across Environments of Absolute Value of GEI Modelled by AMMI (AVAMGE) (Zali et al. 2012)
\mjsdeqn{AV_{(AMGE)} = \sum_{j=1}^{E} \sum_{n=1}^{N'} \left |\lambda_{n}\gamma_{in} \delta_{jn} \right |}
\item Annicchiarico's D Parameter values (Da) (Annicchiarico 1997)
\mjsdeqn{D_{a} = \sqrt{\sum_{n=1}^{N'}(\lambda_{n}\gamma_{in})^2}}
\item Zhang's D Parameter (Dz) (Zhang et al. 1998)
\mjsdeqn{D_{z} = \sqrt{\sum_{n=1}^{N'}\gamma_{in}^{2}}}
\item Sums of the Averages of the Squared Eigenvector Values (EV) (Zobel 1994)
\mjsdeqn{EV = \sum_{n=1}^{N'}\frac{\gamma_{in}^2}{N'}}
\item Stability Measure Based on Fitted AMMI Model (FA) (Raju 2002)
\mjsdeqn{FA = \sum_{n=1}^{N'}\lambda_{n}^{2}\gamma_{in}^{2}}
\item Modified AMMI Stability Index (MASI) (Ajay et al. 2018)
\mjsdeqn{MASI = \sqrt{ \sum_{n=1}^{N'} PC_{n}^{2} \times \theta_{n}^{2}}}
\item Modified AMMI Stability Value (MASV) (Ajay et al. 2019)
\mjsdeqn{MASV = \sqrt{\sum_{n=1}^{N'-1}\left (\frac{SSIPC_{n}}{SSIPC_{n+1}} \right ) \times (PC_{n})^2   + \left (PC_{N'}\right )^2}}
\item Sums of the Absolute Value of the IPC Scores (SIPC) (Sneller et al. 1997)
\mjsdeqn{SIPC = \sum_{n=1}^{N'} | \lambda_{n}^{0.5}\gamma_{in}|}
\item Absolute Value of the Relative Contribution of IPCs to the Interaction (Za) (Zali et al. 2012)
\mjsdeqn{Za = \sum_{i=1}^{N'} | \theta_{n}\gamma_{in} |}
\item Weighted average of absolute scores (WAAS) (Olivoto et al. 2019)
\mjsdeqn{WAAS_i = \sum_{k = 1}^{p} |IPCA_{ik} \times \theta_{k}/ \sum_{k = 1}^{p}\theta_{k}}
}

For all the statistics, simultaneous selection indexes (SSI) are also
computed by summation of the ranks of the stability and mean performance,
Y_R, (Farshadfar, 2008).
}
\examples{
\donttest{
library(metan)
model <-
  performs_ammi(data_ge,
                env = ENV,
                gen = GEN,
                rep = REP,
                resp = c(GY, HM))
model_indexes <- ammi_indexes(model)


# Alternatively (and more intuitively) using \%>\%
# If resp is not declared, all traits are analyzed
res_ind <- data_ge \%>\%
           performs_ammi(ENV, GEN, REP, verbose = FALSE) \%>\%
           ammi_indexes()

rbind_fill_id(res_ind, .id = "TRAIT")
}

}
\references{
Ajay BC, Aravind J, Abdul Fiyaz R, Bera SK, Kumar N, Gangadhar K, Kona P
(2018). “Modified AMMI Stability Index (MASI) for stability analysis.”
ICAR-DGR Newsletter, 18, 4–5.

Ajay BC, Aravind J, Fiyaz RA, Kumar N, Lal C, Gangadhar K, Kona P, Dagla MC,
Bera SK (2019). “Rectification of modified AMMI stability value (MASV).”
Indian Journal of Genetics and Plant Breeding (The), 79, 726–731.
https://www.isgpb.org/article/rectification-of-modified-ammi-stability-value-masv.

Annicchiarico P (1997). “Joint regression vs AMMI analysis of
genotype-environment interactions for cereals in Italy.” Euphytica, 94(1),
53–62. \doi{10.1023/A:1002954824178}

Farshadfar E (2008) Incorporation of AMMI stability value and grain yield in
a single non-parametric index (GSI) in bread wheat. Pakistan J Biol Sci
11:1791–1796. \doi{10.3923/pjbs.2008.1791.1796}

Jambhulkar NN, Rath NC, Bose LK, Subudhi HN, Biswajit M, Lipi D, Meher J
(2017). “Stability analysis for grain yield in rice in demonstrations
conducted during rabi season in India.” Oryza, 54(2), 236–240.
\doi{10.5958/2249-5266.2017.00030.3}

Olivoto T, LUcio ADC, Silva JAG, et al (2019) Mean Performance and Stability
in Multi-Environment Trials I: Combining Features of AMMI and BLUP
Techniques. Agron J 111:2949–2960. \doi{10.2134/agronj2019.03.0220}

Raju BMK (2002). “A study on AMMI model and its biplots.” Journal of the
Indian Society of Agricultural Statistics, 55(3), 297–322.

Rao AR, Prabhakaran VT (2005). “Use of AMMI in simultaneous selection of
genotypes for yield and stability.” Journal of the Indian Society of
Agricultural Statistics, 59, 76–82.

Sneller CH, Kilgore-Norquest L, Dombek D (1997). “Repeatability of yield
stability statistics in soybean.” Crop Science, 37(2), 383–390.
\doi{10.2135/cropsci1997.0011183X003700020013x}

Zali H, Farshadfar E, Sabaghpour SH, Karimizadeh R (2012). “Evaluation of
genotype × environment interaction in chickpea using measures of stability
from AMMI model.” Annals of Biological Research, 3(7), 3126–3136.

Zhang Z, Lu C, Xiang Z (1998). “Analysis of variety stability based on AMMI
model.” Acta Agronomica Sinica, 24(3), 304–309.
http://zwxb.chinacrops.org/EN/Y1998/V24/I03/304.

Zobel RW (1994). “Stress resistance and root systems.” In Proceedings of the
Workshop on Adaptation of Plants to Soil Stress. 1-4 August, 1993. INTSORMIL
Publication 94-2, 80–99. Institute of Agriculture and Natural Resources,
University of Nebraska-Lincoln.
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
