% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta_tag}
\alias{meta_tag}
\title{Create a metadata tag for attribute/value pairs}
\usage{
meta_tag(.meta = meta(), ...)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{...}{Attribute names and values as \code{attribute = value}. Values must be
a single character string.}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Creates a \verb{<meta>} tag for attribute value pairs, where argument names
correspond to attribute names.
}
\examples{
meta() \%>\%
  meta_tag(
    "http-equiv" = "Content-Security-Policy",
    content = "default-src 'self'"
  )

}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_general}()},
\code{\link{meta_geo}()},
\code{\link{meta_google_scholar}()},
\code{\link{meta_name}()},
\code{\link{meta_social}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
