% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meteESF.R
\name{meteESF}
\alias{meteESF}
\title{meteESF}
\usage{
meteESF(spp, abund, power, S0 = NULL, N0 = NULL, E0 = NULL, minE)
}
\arguments{
\item{spp}{A vector of species names}

\item{abund}{A vector of abundances}

\item{power}{A vector of metabolic rates}

\item{S0}{Total number of species}

\item{N0}{Total number of individuals}

\item{E0}{Total metabolic rate; defaults to N0*1e6 if not specified or
calculated from \code{power} to allow one to fit models that
do not depend on metabolic rates}

\item{minE}{Minimum possible metabolic rate}
}
\value{
An object of class \code{meteESF} with elements
\describe{
  \item{\code{data}}{The data used to construct the ESF}
  \item{\code{emin}}{The minimum metabolic rate used to rescale metabolic rates}
  \item{\code{La}}{Vector of Lagrange multipliers}
  \item{\code{La.info}}{Termination information from optimization procedure}
  \item{\code{state.var}}{State variables used to constrain entropy maximization}
  \item{\code{Z}}{Normalization constant for ESF}
}
}
\description{
\code{meteESF} Calculates the ``ecosystem structure
function'' \eqn{R(n,\epsilon)} which forms the core of the Maximum Entropy Theory of
Ecology
}
\details{
Uses either data or state variables to calculate the Ecosystem Structure
Function (ESF). \code{power} nor \code{E0} need not be specified; if missing an arbitrarily
large value is assigned to E0 (N0*1e5) such that it will minimally affect
estimation of Lagrange multipliers. Consider using sensitivity analysis to
confirm this assumption. Examples show different ways of combining data and state
variables to specify constraints
}
\examples{
## case where complete data availible
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
esf1

## excluding metabolic rate data
esf2 <- meteESF(spp=arth$spp,
                abund=arth$count)
esf2

## using state variables only
esf3 <- meteESF(S0=50, N0=500, E0=5000)
esf3
esf4 <- meteESF(S0=50, N0=500)
esf4
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
metePi
}
\keyword{METE,}
\keyword{MaxEnt,}
\keyword{ecosystem}
\keyword{function}
\keyword{lagrange}
\keyword{multiplier,}
\keyword{structure}

