% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micer.R
\name{miceCompare}
\alias{miceCompare}
\title{miceCompare}
\usage{
miceCompare(ref, result1, result2, reps)
}
\arguments{
\item{ref}{column of reference labels as factor data type.}

\item{result1}{column of predicted labels as factor data type (first result to compare).}

\item{result2}{column of predicted labels as factor data type (second result to compare).}

\item{reps}{number of bootstrap replicates to use. Default is 200.}
}
\value{
paired t-test results including t-statistic, degrees of freedom, p-value, 95\% confidence interval, and mean difference
}
\description{
Statistically compare two models using a paired t-test and bootstrap samples of the assessment results
}
\examples{
data(compareData)
compareResult <- miceCompare(ref=compareData$ref,
result1=compareData$rfPred,
result2=compareData$dtPred,
reps=100)
print(compareResult)
}
