% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_single_plate.R
\name{tidy_single_plate}
\alias{tidy_single_plate}
\title{Tidy single 96-well plate via parameters}
\usage{
tidy_single_plate(
  input_data,
  direction = c("horizontal", "vertical"),
  group_ID = NULL,
  experiment_name = NULL,
  validity_method = c("threshold", "invalid"),
  threshold = NULL,
  invalid_samples = NULL,
  treatment_labels,
  concentration_levels,
  ...
)
}
\arguments{
\item{input_data}{Either a file path or a data frames with 8 rows and 12 columns.}

\item{direction}{A character vector specifying the orientation of the plate layout.
It can be either "horizontal" or "vertical".}

\item{group_ID}{A character vector providing group identifiers for each experiment.}

\item{experiment_name}{A string providing the name of the experiment. The hierarchy is group > experiment, i.e.
within a single group, there might be several experiments taking place (e.g. multiple extracts from the same plant species
tested with plant species being the group and type of extract being the experiment).}

\item{validity_method}{A character vector specifying the method for determining cell validity. 
It can be either "threshold" (i.e. samples are validated based on a common absorption maximum) or "samples" (i.e. samples are manually specified as invalid).}

\item{threshold}{A numeric threshold value. Applied if \code{validity_method} is set to 'threshold'.}

\item{invalid_samples}{A character vector containing well positions (e.g. "A-3", "B-8",...) of invalid samples. Applied if \code{validity_method} is set to 'samples'.}

\item{treatment_labels}{A character vector containing treatment labels.}

\item{concentration_levels}{A numeric vector containing concentration levels.}

\item{...}{Additional arguments to be passed to \code{\link{read_plates}}.}
}
\value{
A tidy tibble containing data and metadata.
}
\description{
This function processes a single raw 96-well plate data from a photometer measurement by adding metadata via user-specified parameter values.
}
\details{
This function processes photometer data from a single measurement and adds metadata based on user-set parameters.
It supports two methods for determining cell validity: "threshold" and "invalid". If "threshold" method is chosen,
the validity of each cell is determined based on a specified threshold value. If "sample" method is chosen, samples
at specified well positions on the plate are considered invalid. The function generates lists of treatments and
concentration levels based on the direction parameter, i.e. the direction of the treatments and concentration levels
applied (either horizontally or vertically on the plate). To add metadata to several plates at the same time, the
functions \code{tidy_plates_via_params} and \code{tidy_plates_via_prompts} are recommended.

For all three functions, \code{tidy_plate}, \code{tidy_plates_via_params}, and \code{tidy_plates_via_prompts}, to work
properly, file names should provide a file identifier (i.e. "bma" in
case there are additional but unused files in the folder), an identifier for experiments (starting with "exp" followed
by a number, e.g. "exp1") and an identifier for timepoints (starting with the upper- or lower-case letter t followed
by a number, e.g. "T0" or "t0").
}
\examples{
# Load example data
data(bma)
# Add metadata from user parameters
bma_tidy <- tidy_single_plate(input_data = bma[1],
                       direction = "horizontal",
                       group_ID = "Group A",
                       experiment_name = "Experiment 1",
                       validity_method = "threshold",
                       threshold = 1,
                       treatment_labels = LETTERS[1:8],
                       concentration_levels = seq(from=80, to=10, length.out=8))
bma_tidy # View tidy data
}
\seealso{
\code{\link{tidy_plates_via_params}}, \code{\link{tidy_plates_via_prompts}}
}
