% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth.R
\name{kdens_bandwidth}
\alias{kdens_bandwidth}
\title{Optimal scale matrix for kernel density estimation}
\usage{
kdens_bandwidth(
  x,
  beta,
  shift,
  family = c("mig", "hsgauss", "tnorm"),
  method = c("amise", "lcv", "lscv", "rlcv"),
  type = c("isotropic", "diag", "full"),
  approx = c("kernel", "mig", "tnorm"),
  transformation = c("none", "scaling", "spherical"),
  N = 10000L,
  buffer = 0,
  maxiter = 2000L,
  ...
)
}
\arguments{
\item{x}{an \code{n} by \code{d} matrix of observations}

\item{beta}{\code{d} vector defining the half-space}

\item{shift}{location vector for translating the half-space. If missing, defaults to zero}

\item{family}{distribution for smoothing, either \code{mig} for multivariate inverse Gaussian, \code{tnorm} for truncated normal on the half-space and \code{hsgauss} for the Gaussian smoothing after suitable transformation.}

\item{method}{estimation criterion, either \code{amise} for the expression that minimizes the asymptotic integrated squared error, \code{lcv} for likelihood (leave-one-out) cross-validation, \code{lscv} for least-square cross-validation or \code{rlcv} for robust cross validation of Wu (2019)}

\item{type}{string indicating whether to compute an isotropic model or estimate the optimal scale matrix via optimization}

\item{approx}{string; distribution to approximate the true density function \eqn{f(x)}; either \code{kernel} for the kernel estimator evaluated at the sample points (except for \code{method="amise"}, which isn't supported),  \code{mig} for multivariate inverse Gaussian with the method of moments or \code{tnorm} for the multivariate truncated Gaussian evaluated by maximum likelihood.}

\item{transformation}{string for optional scaling of the data before computing the bandwidth. Either standardization to unit variance \code{scaling}, spherical transformation to unit variance and zero correlation (\code{spherical}), or \code{none} (default).}

\item{N}{integer number of simulations for Monte Carlo integration}

\item{buffer}{double indicating the buffer from the half-space}

\item{maxiter}{integer; max number of iterations in the call to \code{optim}.}

\item{...}{additional parameters, currently ignored}
}
\value{
a \code{d} by \code{d} scale matrix
}
\description{
Given an \code{n} sample from a multivariate distribution on the half-space defined by
\eqn{\{\boldsymbol{x} \in \mathbb{R}^d: \boldsymbol{\beta}^\top\boldsymbol{x}>0\}},
the function computes the bandwidth (\code{type="isotropic"}) or scale
matrix that minimizes the asymptotic mean integrated squared error away from the boundary.
The latter depend on the true unknown density, which is replaced by the kernel density or
 a MIG distribution evaluated at the maximum likelihood estimator. The integral or the integrated
 squared error are obtained by Monte Carlo integration with \code{N} simulations
}
\references{
Wu, X. (2019). Robust likelihood cross-validation for kernel density estimation. \emph{Journal of Business & Economic Statistics}, 37(\bold{4}), 761–770. \doi{10.1080/07350015.2018.1424633}
Bowman, A.W. (1984). An alternative method of cross-validation for the smoothing of density estimates, \emph{Biometrika}, 71(\bold{2}), 353–360. \doi{10.1093/biomet/71.2.353}
Rudemo, M. (1982). Empirical choice of histograms and kernel density estimators. \emph{Scandinavian Journal of Statistics}, 9(\bold{2}), 65–78. http://www.jstor.org/stable/4615859
}
