% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_feats.R
\name{get_corr_feats}
\alias{get_corr_feats}
\title{Identify correlated features}
\usage{
get_corr_feats(
  features,
  corr_thresh = 1,
  group_neg_corr = TRUE,
  corr_method = "spearman"
)
}
\arguments{
\item{features}{a dataframe with each column as a feature for ML}

\item{corr_thresh}{For feature importance, group correlations above or equal
to \code{corr_thresh} (range \code{0} to \code{1}; default: \code{1}).}

\item{group_neg_corr}{Whether to group negatively correlated features
together (e.g. c(0,1) and c(1,0)).}

\item{corr_method}{correlation method. options or the same as those supported
by \code{stats::cor}: spearman, pearson, kendall. (default: spearman)}
}
\value{
Dataframe of correlated features where the columns are feature1,
feature2, and the correlation between those two features
(anything exceeding corr_thresh).
}
\description{
Identify correlated features
}
\author{
Begüm Topçuoğlu, \email{topcuoglu.begum@gmail.com}

Zena Lapp, \email{zenalapp@umich.edu}
}
\keyword{internal}
