test_that("minHalfFact basic functionality works", {
  # Call the internal function directly (since it's not exported)
  result <- min2HalfFFD:::minHalfFact(Number_of_Factors = 3, lower_bound = 0, upper_bound = 1)

  # Check that it returns a list with key components
  expect_type(result, "list")
  expect_true("Max_D_value" %in% names(result))
  expect_true("Total_Minimally_Changed_Factorial_Run_Orders" %in% names(result))

  # Sanity checks on numeric outputs
  expect_true(is.numeric(result$Max_D_value))
  expect_true(is.numeric(result$Max_Trend_factor_value))
  expect_gte(result$Total_Minimally_Changed_Factorial_Run_Orders, 0)
})
