% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{pdf_scale}
\alias{pdf_scale}
\title{Modify global transformation matrix with additional scaling}
\usage{
pdf_scale(doc, x, y = x)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{x, y}{scale amount in each direction. If 'y' value is not specified
it is made the same as the 'x' value}
}
\value{
\code{pdf_doc}
}
\description{
Global transformations are cumulative, and these is no operation to reset
the global transformation.
For local transformations use the \code{tf} argument for individual objects.
}
\examples{
doc <- create_pdf() |>
   pdf_scale(x = 10)
}
\seealso{
Other transform functions: 
\code{\link{pdf_rotate}()},
\code{\link{pdf_translate}()},
\code{\link{tf_rotate}()},
\code{\link{tf_scale}()},
\code{\link{tf_translate}()}

Other global transform functions: 
\code{\link{pdf_rotate}()},
\code{\link{pdf_translate}()}
}
\concept{global transform functions}
\concept{transform functions}
