% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateNA.R
\name{generateNA}
\alias{generateNA}
\title{Generate Missing Values Completely at Random}
\usage{
generateNA(dat, pmiss = 0.2, seed = 123)
}
\arguments{
\item{dat}{complete data.frame.}

\item{pmiss}{proportion of NA.}

\item{seed}{seed value to ensure reproducibility.}
}
\value{
data.frame with the desired proportion of missing values.
}
\description{
Introducing a proportion of missing values given a data.frame under Missing Completely at Random mechanism (MCAR).
}
\section{Details}{

This function is made only for experimental purpose. Whithout specifying the columns (i.e. variables), missing values are introduced to all columns of the dataset.
}

\examples{

data(iris)
# introduce 30\% of NA
irisNA <- generateNA(iris, 0.3)
# check the proportion of NA
 mean(is.na(irisNA))
}
