% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{param_ebal}
\alias{param_ebal}
\title{Construct parameter list for ebalance}
\usage{
param_ebal(
  coefs = NULL,
  max.iterations = 200,
  base.weight = NULL,
  constraint.tolerance = 1,
  norm.constant = NULL,
  trim = FALSE,
  max.weight = NULL,
  min.weight = 0,
  max.trim.iterations = 200,
  max.weight.increment = 0.92,
  min.weight.increment = 1.08
)
}
\arguments{
\item{coefs}{starting values for model coefficients.}

\item{max.iterations}{maximum number of iterations.}

\item{base.weight}{vector of base weights.}

\item{constraint.tolerance}{tolerance level.}

\item{norm.constant}{An optional normalizing constant.}

\item{trim}{trim weights via \code{\link[ebal]{ebalance.trim}}}

\item{max.weight}{Target for the ratio of the maximum to mean weight.}

\item{min.weight}{Target for the ratio of the minimum to mean weight.}

\item{max.trim.iterations}{Maximum number of trimming iterations.}

\item{max.weight.increment}{Increment for iterative trimming of the
ratio of the maximum to mean weight.}

\item{min.weight.increment}{Increment for iterative trimming of the
ratio of the minimum to mean weight.}
}
\value{
A \code{list} of parameters that can be passed to \code{\link[=missDiag]{missDiag()}}.
}
\description{
Construct parameter list for ebalance
}
\details{
For more information about these parameters, see
\code{\link[ebal:ebalance]{ebal::ebalance()}} and \code{\link[ebal:ebalance.trim]{ebal::ebalance.trim()}}.
}
