% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{set_opt}
\alias{set_opt}
\title{Set Parameters}
\usage{
set_opt(...)
}
\arguments{
\item{...}{arguments in tag = value form, or a list of tagged values.}
}
\value{
When parameters are set, their previous values are returned in an invisible named list.
}
\description{
Function can be used to set the parameters used in \code{\link{mistr}}.
}
\details{
The function can set the values for:

         \strong{sub} parameter: small value that is used in mixture quantile function 
                                 to test if the computed value is infimum, default: 1e-10. 
                                 
         \strong{add} parameter: small value that is added to values that are in the image of CDF in \code{\link{qlim}}
                                 function, default: 1e-08.
                                 
         \strong{tol} parameter: tolerance for uniroot used in mixture quantile function, default: .Machine$double.eps^0.5.
}
\examples{
a <- set_opt(sub = 1e-5, tol = 1e-10)
get_opt("sub", "tol")
set_opt(a) 
}
