% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_helper_functions.R
\name{create_day_diff_matrix}
\alias{create_day_diff_matrix}
\title{Create Day Difference Matrix}
\usage{
create_day_diff_matrix(dates)
}
\arguments{
\item{dates}{vector; dates of symptom onset for each case. Can be Date objects
or any format coercible to dates}
}
\value{
numeric matrix; symmetric matrix where element \code{[i,j]} represents the
number of days between case i and case j (positive if i occurs after j)
}
\description{
Creates a symmetric matrix containing the time differences (in days) between
all pairs of cases based on their symptom onset dates.
}
\examples{
# Create day difference matrix from onset dates
onset_dates <- as.Date(c("2023-01-01", "2023-01-04", "2023-01-07", "2023-01-10"))
day_differences <- create_day_diff_matrix(onset_dates)
print(day_differences)

}
