% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f0.R
\name{f0}
\alias{f0}
\title{Calculate f0 for Different Components}
\usage{
f0(x, mu, sigma, comp, dist = "normal")
}
\arguments{
\item{x}{numeric; the value at which to evaluate the function.}

\item{mu}{numeric; the mean value.}

\item{sigma}{numeric; the standard deviation.}

\item{comp}{integer; the component number (1 to 7).}

\item{dist}{string; assumed distribution of the serial interval; takes "normal" or "gamma"; defaults to "normal"}
}
\value{
The calculated value of f0.
}
\description{
This function calculates the value of f0 based on the component, where the components
represent the transmission routes: Co-Primary (CP), Primary-Secondary (PS), Primary-Tertiary (PT), and Primary-Quaternary (PQ). We split the PS, PT and PQ routes into two parts, such that
\itemize{
\item component 1: CP route
\item component 2+3: PS route
\item component 4+5: PT route
\item component 6+7: PQ route
}
}
\details{
If the dist = gamma, then the mean (\eqn{\mu}) and standard deviation (sigma) are converted into the
shape (k) and scale (theta) parameters for the gamma distribution, such that the mean (\eqn{\mu}
) and variance (\eqn{\sigma^2}) are given by:
\deqn{\mu = k \times \theta}
\deqn{\sigma^2 = k \times \theta^2}.
}
\examples{
# Basic example with normal distribution
# Component 2 represents primary-secondary transmission
f0(x = 0.5, mu = 12, sigma = 3, comp = 2, dist = "normal")

# Same parameters with gamma distribution
f0(x = 0.5, mu = 12, sigma = 3, comp = 2, dist = "gamma")

# Component 1 represents co-primary transmission
f0(x = 0.3, mu = 8, sigma = 2, comp = 1, dist = "normal")

# Calculate for all transmission route components
x_val <- 0.4
mu_val <- 10
sigma_val <- 3

# Components 1-7 represent different transmission routes:
# 1: Co-Primary, 2+3: Primary-Secondary, 4+5: Primary-Tertiary, 6+7: Primary-Quaternary
sapply(1:7, function(comp) {
  f0(x_val, mu_val, sigma_val, comp, "normal")
})
}
