% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_diagnostic_functions.R
\name{residuals.mixpoissonreg}
\alias{residuals.mixpoissonreg}
\title{Residuals Method for \code{mixpoissonreg} Objects}
\usage{
\method{residuals}{mixpoissonreg}(object, type = c("pearson", "score"), ...)
}
\arguments{
\item{object}{an object of class "mixpoissonreg" containing results from the fitted model.}

\item{type}{the type of residual to be returned. Currently, the options are 'pearson' or 'score'. The default is set to 'pearson'. Notice that these
residuals coincide for Negative-Binomial models.}

\item{...}{Currently not used.}
}
\value{
A vector containing the residuals of a \emph{mixpoissonreg} object.
}
\description{
Function to return 'pearson' or 'score' residuals for mixed Poisson regression models.
}
\examples{

daysabs_prog <- mixpoissonreg(daysabs ~ prog, data = Attendance)
residuals(daysabs_prog)

}
\seealso{
\code{\link{plot.mixpoissonreg}}, \code{\link{predict.mixpoissonreg}},
\code{\link{autoplot.mixpoissonreg}}, \code{\link{summary.mixpoissonreg}}
}
