% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_rforest.R
\name{mlRforest}
\alias{mlRforest}
\alias{ml_rforest}
\alias{mlRforest.formula}
\alias{mlRforest.default}
\alias{predict.mlRforest}
\title{Supervised classification and regression using random forest}
\usage{
mlRforest(train, ...)

ml_rforest(train, ...)

\method{mlRforest}{formula}(
  formula,
  data,
  ntree = 500,
  mtry,
  replace = TRUE,
  classwt = NULL,
  ...,
  subset,
  na.action
)

\method{mlRforest}{default}(
  train,
  response,
  ntree = 500,
  mtry,
  replace = TRUE,
  classwt = NULL,
  ...
)

\method{predict}{mlRforest}(
  object,
  newdata,
  type = c("class", "membership", "both", "vote"),
  method = c("direct", "oob", "cv"),
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to \code{\link[randomForest:randomForest]{randomForest::randomForest()}} or its
\code{\link[=predict]{predict()}} method. There are many more arguments, see the corresponding
help page.}

\item{formula}{a formula with left term being the factor variable to predict
(for supervised classification), a vector of numbers (for regression) or
nothing (for unsupervised classification) and the right term with the list
of independent, predictive variables, separated with a plus sign. If the
data frame provided contains only the dependent and independent variables,
one can use the \code{class ~ .} short version (that one is strongly encouraged).
Variables with minus sign are eliminated. Calculations on variables are
possible according to usual formula convention (possibly protected by using
\code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{ntree}{the number of trees to generate (use a value large enough to get
at least a few predictions for each input row). Default is 500 trees.}

\item{mtry}{number of variables randomly sampled as candidates at each split.
Note that the default values are different for classification (sqrt(p)
where p is number of variables in x) and regression (p/3)?}

\item{replace}{sample cases with or without replacement (\code{TRUE} by default)?}

\item{classwt}{priors of the classes. Need not add up to one. Ignored for
regression.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_rforest]{ml_rforest()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor (classification) or numeric (regression),
or \code{NULL} (unsupervised classification).}

\item{object}{an \strong{mlRforest} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"membership"} the membership (number
between 0 and 1) to the different classes as assessed by the number of
neighbors of these classes, or \code{"both"} to return classes and memberships.
One can also use \code{"vote"}, which returns the number of trees that voted
for each class.}

\item{method}{\code{"direct"} (default), \code{"oob"} or \code{"cv"}. \code{"direct"} predicts
new cases in \verb{newdata=} if this argument is provided, or the cases in the
training set if not. Take care that not providing \verb{newdata=} means that you
just calculate the \strong{self-consistency} of the classifier but cannot use
the metrics derived from these results for the assessment of its
performances (in the case of Random Forest, these metrics would most
certainly falsely indicate a perfect classifier). Either use a different
data set in \verb{newdata=} or use the alternate approaches: out-of-bag
(\code{"oob"}) or cross-validation ("cv"). The out-of-bag approach uses
individuals that are not used to build the trees to assess performances. It
is an unbiased estimates. If you specify \code{method = "cv"} then \code{\link[=cvpredict]{cvpredict()}}
is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_rforest]{ml_rforest()}}/\code{\link[=mlRforest]{mlRforest()}} creates an \strong{mlRforest}, \strong{mlearning}
object containing the classifier and a lot of additional metadata used by
the functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the random forest algorithm
provided by \code{\link[randomForest:randomForest]{randomForest::randomForest()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_rf <- ml_rforest(data = iris_train, Species ~ .)
summary(iris_rf)
plot(iris_rf) # Useful to look at the effect of ntree=
# For such a relatively simple case, 50 trees are enough
iris_rf <- ml_rforest(data = iris_train, Species ~ ., ntree = 50)
summary(iris_rf)
predict(iris_rf) # Default type is class
predict(iris_rf, type = "membership")
predict(iris_rf, type = "both")
predict(iris_rf, type = "vote")
# Out-of-bag prediction (unbiased)
predict(iris_rf, method = "oob")
# Self-consistency (always very high for random forest, biased, do not use!)
confusion(iris_rf)
# This one is better
confusion(iris_rf, method = "oob") # Out-of-bag performances
# Cross-validation prediction is also a good choice when there is no test set
predict(iris_rf, method = "cv")  # Idem: cvpredict(res)
# Cross-validation for performances estimation
confusion(iris_rf, method = "cv")
# Evaluation of performances using a separate test set
confusion(predict(iris_rf, newdata = iris_test), iris_test$Species)

# Regression using random forest (from ?randomForest)
set.seed(131) # Useful for reproducibility (use a different number each time)
ozone_rf <- ml_rforest(data = airquality, Ozone ~ ., mtry = 3,
  importance = TRUE, na.action = na.omit)
summary(ozone_rf)
# Show "importance" of variables: higher value mean more important variables
round(randomForest::importance(ozone_rf), 2)
plot(na.omit(airquality)$Ozone, predict(ozone_rf))
abline(a = 0, b = 1)

# Unsupervised classification using random forest (from ?randomForest)
set.seed(17)
iris_urf <- ml_rforest(train = iris[, -5]) # Use only quantitative data
summary(iris_urf)
randomForest::MDSplot(iris_urf, iris$Species)
plot(stats::hclust(stats::as.dist(1 - iris_urf$proximity),
  method = "average"), labels = iris$Species)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also
\code{\link[randomForest:randomForest]{randomForest::randomForest()}} that actually does the classification.
}
