% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlearning-package.R
\docType{package}
\name{mlearning-package}
\alias{mlearning-package}
\title{Machine Learning Algorithms with Unified Interface and Confusion Matrices}
\description{
This package provides wrappers around several existing machine learning
algorithms in R, under a unified user interface. Confusion matrices can also
be calculated and viewed as tables or plots. Key features are:
\itemize{
\item Unified, formula-based interface for all algorithms, similar to
\code{\link[stats:lm]{stats::lm()}}.
\item Optimized code when a simplified formula \code{y ~ .} is used, meaning all
variables in data are used (one of them (\code{y} here) is the class to be
predicted (classification problem, a factor variable), or the dependent
variable of the model (regression problem, a numeric variable).
\item Similar way of dealing with missing data, both in the training set and in
predictions. Underlying algorithms deal differently with missing data. Some
accept them, other not.
\item Unified way of dealing with factor levels that have no cases in the
training set. The training succeeds, but the classifier is, of course, unable
to classify items in the missing class.
\item The \code{\link[=predict]{predict()}} methods have similar arguments. They return the class,
membership to the classes, both, or something else (probabilities,
raw predictions, ...) depending on the algorithm or the problem
(classification or regression).
\item The \code{\link[=cvpredict]{cvpredict()}} method is available for all algorithms and it performs
very easily a cross-validation, or even a leave_one_out validation (when
\code{cv.k} = number of cases). It operates transparently for the end-user.
\item The \code{\link[=confusion]{confusion()}} method creates a confusion matrix and the object can be
printed, summarized, plotted. Various metrics are easily derived from the
confusion matrix. Also, it allows to adjust prior probabilities of the
classes in a classification problem, in order to obtain more representative
estimates of the metrics when priors are adjusted to values closes to real
proportions of classes in the data.
}

See \code{\link[=mlearning]{mlearning()}} for further explanations and an example analysis. See
\code{\link[=mlLda]{mlLda()}} for examples of the different forms of the formula that can be
used. See \code{\link[=plot.confusion]{plot.confusion()}} for the different ways to explore the confusion
matrix.
}
\section{Important functions}{

\itemize{
\item \code{\link[=ml_lda]{ml_lda()}}, \code{\link[=ml_qda]{ml_qda()}}, \code{\link[=ml_naive_bayes]{ml_naive_bayes()}}, \code{\link[=ml_knn]{ml_knn()}}, \code{\link[=ml_lvq]{ml_lvq()}},
\code{\link[=ml_nnet]{ml_nnet()}}, \code{\link[=ml_rpart]{ml_rpart()}}, \code{\link[=ml_rforest]{ml_rforest()}} and \code{\link[=ml_svm]{ml_svm()}} to train classifiers
or regressors with the different algorithms that are supported in the
package,
\item \code{\link[=predict]{predict()}} and \code{\link[=cvpredict]{cvpredict()}} for predictions, including using
cross-validation,
\item \code{\link[=confusion]{confusion()}} to calculate the confusion matrix (with various methods to
analyze it and to calculate derived metrics like recall, precision, F-score,
...)
\item \code{\link[=prior]{prior()}} to adjust prior probabilities,
\item \code{\link[=response]{response()}} and \code{\link[=train]{train()}} to extract response and training variables from
an \strong{mlearning} object.
}
}

