% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_MLmodels.R
\name{train_svr}
\alias{train_svr}
\title{Train Support Vector Regression (SVR) model}
\usage{
train_svr(data, formula)
}
\arguments{
\item{data}{A data frame containing the training data.}

\item{formula}{A formula specifying the model.}
}
\value{
A trained \code{svm} model object from the \pkg{e1071} package.
}
\description{
Train Support
}
\details{
Trains an SVR model using the radial kernel.
}
\examples{
\donttest{
# Load required package
library(e1071)

# Use built-in dataset
data(mtcars)

# Define regression formula
svr_formula <- mpg ~ cyl + disp + hp + wt

# Train SVR model
svr_model <- train_svr(data = mtcars, formula = svr_formula)

# Print model summary
print(svr_model)

# Predict on the same data (for illustration)
preds <- predict(svr_model, newdata = mtcars)
head(preds)
}
}
