\name{mmabig-package}
\alias{mmabig-package}
\docType{package}
\title{
Mediation Analysis Package for Big Data Sets
}
\description{
This package is used to identify mediators and for general mediation analysis with big data sets. Mediation effect refers to the effect conveyed by intervening variables to an observed relationship between an exposure and a response variable (outcome).  In this package, the exposure is called the predictor, the intervening variables are called mediators.  The mediation effects include the total effect, direct effect, and indirect effect, which are defined and the statistical inferences described in Li and Yu (2018).
}
\details{
\code{"\link[=data.org.big]{data.org.big}"} is used to identify potential mediators. \code{"\link[=med.big]{med.big}"} , and \code{"\link[=mma.big]{mma.big}"} is a combined function that automatically identify potential mediators, based on which to make statistical inference on the mediation effects.
}
\author{
Qingzhao Yu  \email{qyu@lsuhsc.edu} and Bin Li \email{bli@lsu.edu}

Maintainer: Qingzhao Yu  \email{qyu@lsuhsc.edu}
}
\references{
Yu, Q., Fan, Y., and Wu, X. (2014) <doi:10.4172/2155-6180.1000189>. "General Multiple Mediation Analysis With an Application to Explore Racial Disparity in Breast Cancer Survival," Journal of Biometrics & Biostatistics,5(2): 189. 

Yu, Q., Scribner, R.A., Leonardi, C., Zhang, L., Park, C., Chen, L., and Simonsen, N.R. (2017) <doi:10.1016/j.sste.2017.02.001>. "Exploring racial disparity in obesity: a mediation analysis considering geo-coded environmental factors," Spatial and Spatio-temporal Epidemiology, 21, 13-23. 

Yu, Q., and Li, B. (2017) <doi:10.5334/hors.160>. "mma: An r package for multiple mediation analysis," Journal of Open Research Software, 5(1), 11. 

Li, B. and Yu, Q. (2018). "Mediation Analysis with Large Data Sets". 

Yu, Q. and Li, B., 2022. Statistical Methods for Mediation, Confounding and Moderation Analysis Using R and SAS. Chapman and Hall/CRC. ISBN 9780367365479.
}
\keyword{ Package }

