% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{discretizeVariableToRanges}
\alias{discretizeVariableToRanges}
\title{Discretize a continuous random variable to ranges/buckets.}
\usage{
discretizeVariableToRanges(
  data,
  openEndRanges = TRUE,
  numRanges = NA,
  exclMinVal = NULL,
  inclMaxVal = NULL
)
}
\arguments{
\item{data}{a vector with numeric data}

\item{openEndRanges}{boolean default True. If true, then the minimum value
of the first range will be set to @seealso \code{.Machine$double.xmin} and
the maximum value of the last range will be set to @seealso \code{.Machine$double.xmax},
so that all values get covered.}

\item{numRanges}{integer default NA. If NULL, then the amount of ranges
(buckets) depends on the amount of data given. A minimum of two buckets is
used then, and a maximum of ceiling(log2(length(data))).}

\item{exclMinVal}{numeric default NULL. Used to delimit the lower bound of
the given data. If not given, then no value is excluded, as the exclusive
lower bound becomes the minimum of the given data minus an epsilon of 1e-15.}

\item{inclMaxVal}{numeric default NULL. Used to delimit the upper bound of
the given data. If not given, then the upper inclusive bound is the max of
the given data.}
}
\value{
List a List of vectors, where each vector has two values, the first
being the exclusive minimum value of the range, and the second being the
inclusive maximum value of the range. The list will be as long as the number
of buckets requested.
}
\description{
Discretizes a continuous random variable into buckets (ranges).
Each range is delimited by an exclusive minimum value and an inclusive maximum value.
}
\examples{
buckets <- mmb::discretizeVariableToRanges(
  data = iris$Sepal.Length, openEndRanges = TRUE)

length(buckets)
buckets[[5]]
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{discretization}
