% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghinstall.R
\name{ghinstall}
\alias{ghinstall}
\title{ghinstall}
\usage{
ghinstall(type = c("py", "R"), force = FALSE)
}
\arguments{
\item{type}{character: programm type (default: \code{py})}

\item{force}{logical: should the installation really done (default: `NA)}
}
\value{
\code{NULL} if \code{type} is not found, otherwise \code{type}
}
\description{
If the user agrees, it installs additional software necessary for running a script.
Currently, only \code{type=="py"} for Python scripts and \verb{type=="R"`` for R scripts are supported. When a repository is downloaded, }ghinstall\verb{is called once. If the user calls}ghinstall\verb{for an update, the parameter}force=TRUE` must be set.
}
\details{
\describe{
\item{\code{R}}{\code{mmstat4} \code{init_R.R} is opened if present in the active repository.}
\item{\code{py}}{\code{mmstat4} internally utilizes a virtual environment named \code{mmstat4.xxxx},
where xxxx\verb{, varies depending on the repository. When }ghinstall\verb{is invoked, it verifies the existence of the virtual environment}mmstat4.xxxx\verb{. If it does not exist, the environment is created, and }init_py.R`
is opened if present in the active repository.}
}
}
\examples{
# to delete the virtual environment use
# reticulate::virtualenv_remove('mmstat4')
if (interactive()) ghinstall()
}
