% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_functions_multivariate.R
\name{mvtdiff_distributions}
\alias{mvtdiff_distributions}
\alias{dmvtdiff}
\alias{pmvtdiff}
\alias{rmvtdiff}
\title{Distribution Functions for Multivariate Approximated t-Difference}
\usage{
dmvtdiff(x, mm_result, log = FALSE)

pmvtdiff(q, mm_result, lower.tail = TRUE)

rmvtdiff(n, mm_result)
}
\arguments{
\item{x}{Matrix of quantiles (n x p) or vector for single point}

\item{mm_result}{Result from mm_tdiff_multivariate_general()}

\item{log}{Logical; if TRUE, returns log density}

\item{q}{Vector of quantiles (length p) for cumulative probability}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P(X <= x)}

\item{n}{Number of observations}
}
\value{
For \code{dmvtdiff}: Numeric vector of density values.
For \code{pmvtdiff}: Numeric scalar of cumulative probability.
For \code{rmvtdiff}: Matrix of random samples (n x p).
}
\description{
Distribution Functions for Multivariate Approximated t-Difference
}
\details{
These functions implement the distribution functions for the approximated
multivariate t-difference based on Theorem 3 from the paper.

**Note on degrees of freedom:**
\itemize{
  \item \code{dmvtdiff} uses the exact (non-integer) nu_star from the paper
  \item \code{pmvtdiff} rounds nu_star to the nearest integer due to
        mvtnorm::pmvt requirements. This introduces minimal approximation
        error when nu_star > 10 (the recommended range).
  \item \code{rmvtdiff} uses the exact (non-integer) nu_star
}
}
\examples{
# Setup
Sigma1 <- matrix(c(1, 0.3, 0.3, 1), 2, 2)
Sigma2 <- matrix(c(1.5, 0.5, 0.5, 1.2), 2, 2)
result <- mm_tdiff_multivariate_general(
  mu1 = c(0, 1), Sigma1 = Sigma1, nu1 = 10,
  mu2 = c(0, 0), Sigma2 = Sigma2, nu2 = 15
)

# Density at a point
dmvtdiff(c(0, 1), result)

# Density at multiple points
x_mat <- matrix(c(0, 1, -1, 0.5), nrow = 2, byrow = TRUE)
dmvtdiff(x_mat, result)

# Cumulative probability
pmvtdiff(c(0, 1), result)

# Random samples
samples <- rmvtdiff(100, result)
head(samples)

}
